*                                                                                  ;
 *    Reading in the 1987 PSID data                                                 ;
 *                                                                                  ;
 *            Karen Dynan 8/26/06                                                   ;
 *                                                                                  ;
 *    We read it all in and then output select variables to a flat                  ;
 *    file to be picked up by STATA.                                                ;
 *                                                                                  ;
 
libname psid 'F:\PSID' ;
filename rawdat 'F:\PSID\raw\fam87.raw' ;
 
 data one;
 
   infile 'F:\PSID\87FAM.DAT'  lrecl=2039 missover;
   INPUT
   V13701 1-3             V13702 4-7             V13703 8-9
   V13704 10-12           V13705 13-17           V13706 18
   V13707 19              V13708 20              V13709 21
   V13710 22              V13711 23              V13712 24
   V13713 25              V13714 26              V13715 27
   V13716 28              V13717 29-32           V13718 33-35
   V13719 36-37           V13720 38              V13721 39-40
   V13722 41              V13723 42              V13724 43-48
   V13725 49              V13726 50-55           V13727 56
   V13728 57-61           V13729 62              V13730 63-67
   V13731 68              V13732 69-73           V13733 74
   V13734 75-78           V13735 79              V13736 80-84
   V13737 85              V13738 86-89           V13739 90-93
   V13740 94              V13741 95-98           V13742 99
   V13743 100-103         V13744 104             V13745 105-108
   V13746 109-112         V13747 113             V13748 114-117
   V13749 118             V13750 119-122         V13751 123
   V13752 124-127         V13753 128             V13754 129-132
   V13755 133             V13756 134             V13757 135
   V13758 136             V13759 137             V13760 138
   V13761 139             V13762 140             V13763 141
   V13764 142             V13765 143             V13766 144
   V13767 145             V13768 146             V13769 147
   V13770 148             V13771 149             V13772 150
   V13773 151             V13774 152             V13775 153
   V13776 154             V13777 155             V13778 156
   V13779 157             V13780 158             V13781 159
   V13782 160             V13783 161             V13784 162
   V13785 163             V13786 164             V13787 165
   V13788 166             V13789 167             V13790 168
   V13791 169             V13792 170             V13793 171
   V13794 172             V13795 173             V13796 174
   V13797 175             V13798 176             V13799 177
   V13800 178             V13801 179             V13802 180
   V13803 181-184         V13804 185             V13805 186-189
   V13806 190             V13807 191-194         V13808 195
   V13809 196-199         V13810 200-203         V13811 204
   V13812 205-208         V13813 209             V13814 210-213
   V13815 214             V13816 215-218         V13817 219
   V13818 220-223         V13819 224             V13820 225
   V13821 226             V13822 227             V13823 228
   V13824 229             V13825 230             V13826 231
   V13827 232             V13828 233             V13829 234
   V13830 235             V13831 236             V13832 237
   V13833 238             V13834 239             V13835 240
   V13836 241             V13837 242             V13838 243
   V13839 244             V13840 245             V13841 246
   V13842 247             V13843 248             V13844 249
   V13845 250             V13846 251             V13847 252
   V13848 253             V13849 254             V13850 255
   V13851 256             V13852 257             V13853 258
   V13854 259             V13855 260             V13856 261
   V13857 262             V13858 263             V13859 264
   V13860 265             V13861 266             V13862 267
   V13863 268             V13864 269             V13865 270
   V13866 271             V13867 272-273         V13868 274
   V13869 275-278         V13870 279             V13871 280-283
   V13872 284             V13873 285             V13874 286-288
   V13875 289             V13876 290-294         V13877 295
   V13878 296-299         V13879 300             V13880 301-304
   V13881 305             V13882 306-307         V13883 308
   V13884 309             V13885 310             V13886 311
   V13887 312             V13888 313             V13889 314
   V13890 315             V13891 316             V13892 317
   V13893 318             V13894 319             V13895 320
   V13896 321-325         V13897 326-330         V13898 331-336
   V13899 337             V13900 338-342         V13901 343-348
   V13902 349-353         V13903 354-358         V13904 359
   V13905 360-365         V13906 366             V13907 367-372
   V13908 373-378         V13909 379-383         V13910 384-388
   V13911 389-394         V13912 395-396         V13913 397-402
   V13914 403-404         V13915 405-410         V13916 411-412
   V13917 413-418         V13918 419-424         V13919 425
   V13920 426-432         V13921 433-437         V13922 438-442
   V13923 443-447         V13924 448             V13925 449-450
   V13926 451             V13927 452             V13928 453-457
   V13929 458             V13930 459-460         V13931 461-465
   V13932 466-470         V13933 471-472         V13934 473-477
   V13935 478             V13936 479-480         V13937 481-485
   V13938 486-487         V13939 488-492         V13940 493
   V13941 494-498         V13942 499-503         V13943 504-505
   V13944 506-510         V13945 511-512         V13946 513-517
   V13947 518-519         V13948 520-524         V13949 525-529
   V13950 530             V13951 531-532         V13952 533-537
   V13953 538-542         V13954 543-544         V13955 545-549
   V13956 550             V13957 551-552         V13958 553-557
   V13959 558-559         V13960 560-564         V13961 565-569
   V13962 570-574         V13963 575-576         V13964 577-581
   V13965 582-583         V13966 584-588         V13967 589-590
   V13968 591-595         V13969 596             V13970 597-601
   V13971 602             V13972 603             V13973 604
   V13974 605             V13975 606             V13976 607
   V13977 608             V13978 609             V13979 610
   V13980 611             V13981 612             V13982 613
   V13983 614             V13984 615             V13985 616
   V13986 617             V13987 618             V13988 619
   V13989 620             V13990 621             V13991 622
   V13992 623             V13993 624             V13994 625
   V13995 626             V13996 627             V13997 628
   V13998 629             V13999 630             V14000 631
   V14001 632             V14002 633             V14003 634
   V14004 635             V14005 636             V14006 637
   V14007 638             V14008 639             V14009 640
   V14010 641             V14011 642             V14012 643
   V14013 644             V14014 645             V14015 646
   V14016 647             V14017 648             V14018 649
   V14019 650             V14020 651             V14021 652
   V14022 653             V14023 654             V14024 655
   V14025 656             V14026 657             V14027 658
   V14028 659             V14029 660             V14030 661
   V14031 662             V14032 663             V14033 664
   V14034 665             V14035 666             V14036 667
   V14037 668             V14038 669             V14039 670
   V14040 671             V14041 672             V14042 673
   V14043 674             V14044 675-676         V14045 677-678
   V14046 679-684         V14047 685-686         V14048 687
   V14049 688-689         V14050 690-691         V14051 692-697
   V14052 698-699         V14053 700             V14054 701-702
   V14055 703-704         V14056 705-710         V14057 711-712
   V14058 713             V14059 714-715         V14060 716-717
   V14061 718-723         V14062 724-725         V14063 726
   V14064 727-728         V14065 729-730         V14066 731-736
   V14067 737-738         V14068 739             V14069 740-743
   V14070 744-749         V14071 750             V14072 751-755
   V14073 756             V14074 757-761         V14075 762-766
   V14076 767-771         V14077 772-776         V14078 777-781
   V14079 782-786         V14080 787-791         V14081 792-796
   V14082 797-801         V14083 802-806         V14084 807-811
   V14085 812-816         V14086 817-821         V14087 822
   V14088 823             V14089 824             V14090 825-828
   V14091 829-832         V14092 833-836         V14093 837-840
   V14094 841-844         V14095 845-848         V14096 849-852
   V14097 853-856         V14098 857-860         V14099 861-864
   V14100 865-868         V14101 869-872         V14102 873-876
   V14103 877-880         V14104 881-884         V14105 885-888
   V14106 889-892         V14107 893-896         V14108 897-900
   V14109 901-904         V14110 905-907         V14111 908-911
   V14112 912-914         V14113 915-916         V14114 917-918
   V14115 919             V14116 920-921         V14117 922-923
   V14118 924-925         V14119 926-927         V14120 928
   V14121 929             V14122 930-931         V14123 932-933
   V14124 934-935         V14125 936             V14126 937
   V14127 938             V14128 939-940         V14129 941
   V14130 942             V14131 943             V14132 944
   V14133 945             V14134 946             V14135 947
   V14136 948             V14137 949             V14138 950
   V14139 951             V14140 952             V14141 953-954
   V14142 955             V14143 956             V14144 957
   V14145 958             V14146 959             V14147 960-961
   V14148 962             V14149 963             V14150 964
   V14151 965             V14152 966             V14153 967
   V14154 968-970         V14155 971-973         V14156 974
   V14157 975-978         V14158 979             V14159 980-983
   V14160 984-987         V14161 988-991         V14162 992
   V14163 993-996         V14164 997             V14165 998
   V14166 999-1001        V14167 1002-1004       V14168 1005-1006
   V14169 1007-1008       V14170 1009            V14171 1010-1013
   V14172 1014-1015       V14173 1016            V14174 1017
   V14175 1018            V14176 1019            V14177 1020
   V14178 1021-1022       V14179 1023-1024       V14180 1025
   V14181 1026-1028       V14182 1029-1031       V14183 1032-1035
   V14184 1036-1037       V14185 1038-1039       V14186 1040-1041
   V14187 1042            V14188 1043-1046       V14189 1047-1048
   V14190 1049-1050       V14191 1051            V14192 1052-1053
   V14193 1054            V14194 1055-1056       V14195 1057
   V14196 1058-1059       V14197 1060            V14198 1061-1062
   V14199 1063            V14200 1064-1065       V14201 1066
   V14202 1067-1068       V14203 1069-1070       V14204 1071-1072
   V14205 1073            V14206 1074            V14207 1075
   V14208 1076-1077       V14209 1078-1081       V14210 1082-1083
   V14211 1084-1085       V14212 1086-1087       V14213 1088-1091
   V14214 1092-1093       V14215 1094-1095       V14216 1096
   V14217 1097-1098       V14218 1099            V14219 1100-1101
   V14220 1102-1103       V14221 1104-1105       V14222 1106
   V14223 1107            V14224 1108-1109       V14225 1110-1111
   V14226 1112-1113       V14227 1114-1115       V14228 1116-1117
   V14229 1118-1119       V14230 1120            V14231 1121-1124
   V14232 1125            V14233 1126            V14234 1127
   V14235 1128            V14236 1129            V14237 1130
   V14238 1131            V14239 1132-1133       V14240 1134
   V14241 1135-1138       V14242 1139-1140       V14243 1141
   V14244 1142-1143       V14245 1144            V14246 1145-1146
   V14247 1147-1148       V14248 1149            V14249 1150-1151
   V14250 1152            V14251 1153-1154       V14252 1155-1157
   V14253 1158-1160       V14254 1161            V14255 1162
   V14256 1163            V14257 1164-1165       V14258 1166-1167
   V14259 1168-1171       V14260 1172-1173       V14261 1174-1175
   V14262 1176-1177       V14263 1178            V14264 1179-1182
   V14265 1183-1184       V14266 1185            V14267 1186
   V14268 1187            V14269 1188-1189       V14270 1190-1191
   V14271 1192            V14272 1193-1195       V14273 1196-1198
   V14274 1199-1202       V14275 1203-1204       V14276 1205-1206
   V14277 1207-1208       V14278 1209            V14279 1210-1213
   V14280 1214-1215       V14281 1216-1217       V14282 1218
   V14283 1219-1220       V14284 1221            V14285 1222-1223
   V14286 1224            V14287 1225-1226       V14288 1227
   V14289 1228-1229       V14290 1230            V14291 1231-1232
   V14292 1233            V14293 1234-1235       V14294 1236-1237
   V14295 1238-1239       V14296 1240            V14297 1241
   V14298 1242-1243       V14299 1244-1247       V14300 1248-1249
   V14301 1250-1251       V14302 1252-1253       V14303 1254-1257
   V14304 1258-1259       V14305 1260-1261       V14306 1262
   V14307 1263-1264       V14308 1265            V14309 1266-1267
   V14310 1268-1269       V14311 1270-1271       V14312 1272
   V14313 1273            V14314 1274-1275       V14315 1276-1277
   V14316 1278-1279       V14317 1280-1281       V14318 1282-1283
   V14319 1284-1285       V14320 1286            V14321 1287
   V14322 1288-1289       V14323 1290            V14324 1291
   V14325 1292            V14326 1293            V14327 1294
   V14328 1295            V14329 1296-1298       V14330 1299-1301
   V14331 1302            V14332 1303-1306       V14333 1307
   V14334 1308-1311       V14335 1312-1315       V14336 1316-1319
   V14337 1320            V14338 1321-1324       V14339 1325-1327
   V14340 1328-1330       V14341 1331-1332       V14342 1333-1334
   V14343 1335            V14344 1336-1339       V14345 1340-1341
   V14346 1342            V14347 1343            V14348 1344
   V14349 1345            V14350 1346            V14351 1347-1348
   V14352 1349-1350       V14353 1351            V14354 1352-1354
   V14355 1355-1357       V14356 1358-1361       V14357 1362-1363
   V14358 1364-1365       V14359 1366-1367       V14360 1368
   V14361 1369-1372       V14362 1373-1374       V14363 1375-1376
   V14364 1377            V14365 1378-1379       V14366 1380
   V14367 1381-1382       V14368 1383            V14369 1384-1385
   V14370 1386            V14371 1387-1388       V14372 1389
   V14373 1390-1391       V14374 1392            V14375 1393-1394
   V14376 1395-1396       V14377 1397-1398       V14378 1399
   V14379 1400            V14380 1401            V14381 1402-1403
   V14382 1404-1407       V14383 1408-1409       V14384 1410-1411
   V14385 1412-1413       V14386 1414-1417       V14387 1418-1419
   V14388 1420-1421       V14389 1422            V14390 1423-1424
   V14391 1425            V14392 1426-1427       V14393 1428-1429
   V14394 1430-1431       V14395 1432            V14396 1433
   V14397 1434-1435       V14398 1436-1437       V14399 1438-1439
   V14400 1440-1441       V14401 1442-1443       V14402 1444-1445
   V14403 1446            V14404 1447            V14405 1448-1449
   V14406 1450            V14407 1451-1452       V14408 1453
   V14409 1454            V14410 1455-1456       V14411 1457-1458
   V14412 1459            V14413 1460-1461       V14414 1462
   V14415 1463-1464       V14416 1465-1467       V14417 1468-1470
   V14418 1471            V14419 1472            V14420 1473
   V14421 1474-1475       V14422 1476-1477       V14423 1478-1481
   V14424 1482-1483       V14425 1484-1485       V14426 1486-1487
   V14427 1488            V14428 1489-1492       V14429 1493-1494
   V14430 1495            V14431 1496            V14432 1497
   V14433 1498-1499       V14434 1500-1501       V14435 1502
   V14436 1503-1505       V14437 1506-1508       V14438 1509-1512
   V14439 1513-1514       V14440 1515-1516       V14441 1517-1518
   V14442 1519            V14443 1520-1523       V14444 1524-1525
   V14445 1526-1527       V14446 1528            V14447 1529-1530
   V14448 1531            V14449 1532-1533       V14450 1534
   V14451 1535-1536       V14452 1537            V14453 1538-1539
   V14454 1540            V14455 1541-1542       V14456 1543
   V14457 1544-1545       V14458 1546-1547       V14459 1548-1549
   V14460 1550            V14461 1551            V14462 1552-1553
   V14463 1554-1557       V14464 1558-1559       V14465 1560-1561
   V14466 1562-1563       V14467 1564-1567       V14468 1568-1569
   V14469 1570-1571       V14470 1572            V14471 1573-1574
   V14472 1575            V14473 1576-1577       V14474 1578-1579
   V14475 1580-1581       V14476 1582            V14477 1583
   V14478 1584-1585       V14479 1586-1587       V14480 1588-1589
   V14481 1590-1591       V14482 1592-1593       V14483 1594-1595
   V14484 1596            V14485 1597-1598       V14486 1599-1600
   V14487 1601            V14488 1602            V14489 1603
   V14490 1604            V14491 1605            V14492 1606
   V14493 1607            V14494 1608            V14495 1609-1614
   V14496 1615            V14497 1616-1617       V14498 1618
   V14499 1619            V14500 1620            V14501 1621
   V14502 1622-1627       V14503 1628            V14504 1629
   V14505 1630            V14506 1631-1632       V14507 1633-1634
   V14508 1635-1636       V14509 1637            V14510 1638
   V14511 1639            V14512 1640            V14513 1641
   V14514 1642            V14515 1643            V14516 1644
   V14517 1645            V14518 1646            V14519 1647-1649
   V14520 1650            V14521 1651            V14522 1652
   V14523 1653            V14524 1654            V14525 1655
   V14526 1656            V14527 1657            V14528 1658
   V14529 1659            V14530 1660-1662       V14531 1663
   V14532 1664            V14533 1665            V14534 1666
   V14535 1667-1668       V14536 1669            V14537 1670
   V14538 1671-1672       V14539 1673            V14540 1674
   V14541 1675-1676       V14542 1677            V14543 1678
   V14544 1679-1680       V14545 1681            V14546 1682
   V14547 1683            V14548 1684            V14549 1685
   V14550 1686            V14551 1687-1688       V14552 1689-1690
   V14553 1691-1692       V14554 1693-1694       V14555 1695-1696
   V14556 1697-1698       V14557 1699            V14558 1700-1701
   V14559 1702            V14560 1703            V14561 1704-1705
   V14562 1706-1707       V14563 1708            V14564 1709
   V14565 1710            V14566 1711-1712       V14567 1713-1714
   V14568 1715-1716       V14569 1717            V14570 1718-1719
   V14571 1720-1721       V14572 1722-1723       V14573 1724
   V14574 1725-1726       V14575 1727-1728       V14576 1729-1730
   V14577 1731-1732       V14578 1733-1734       V14579 1735-1736
   V14580 1737            V14581 1738-1739       V14582 1740-1742
   V14583 1743-1744       V14584 1745-1747       V14585 1748
   V14586 1749            V14587 1750            V14588 1751
   V14589 1752-1753       V14590 1754-1756       V14591 1757
   V14592 1758            V14593 1759            V14594 1760
   V14595 1761            V14596 1762            V14597 1763
   V14598 1764            V14599 1765-1766       V14600 1767
   V14601 1768            V14602 1769-1770       V14603 1771
   V14604 1772            V14605 1773-1774       V14606 1775
   V14607 1776            V14608 1777-1778       V14609 1779
   V14610 1780            V14611 1781            V14612 1782
   V14613 1783            V14614 1784            V14615 1785
   V14616 1786-1787       V14617 1788-1789       V14618 1790-1791
   V14619 1792-1793       V14620 1794-1795       V14621 1796-1797
   V14622 1798-1799       V14623 1800-1801       V14624 1802-1803
   V14625 1804-1805       V14626 1806            V14627 1807-1808
   V14628 1809-1810       V14629 1811            V14630 1812
   V14631 1813-1814       V14632 1815-1816       V14633 1817-1818
   V14634 1819            V14635 1820            V14636 1821
   V14637 1822-1823       V14638 1824-1825       V14639 1826-1827
   V14640 1828-1829       V14641 1830            V14642 1831-1832
   V14643 1833-1834       V14644 1835-1836       V14645 1837-1838
   V14646 1839            V14647 1840-1841       V14648 1842-1843
   V14649 1844-1845       V14650 1846-1847       V14651 1848-1849
   V14652 1850-1851       V14653 1852-1853       V14654 1854
   V14655 1855-1856       V14656 1857-1858       V14657 1859-1863
   V14658 1864-1865       V14659 1866-1869       V14660 1870-1871
   V14661 1872-1875       V14662 1876-1877       V14663 1878-1881
   V14664 1882-1883       V14665 1884-1887       V14666 1888-1889
   V14667 1890-1893       V14668 1894-1895       V14669 1896-1900
   V14670 1901-1907       V14671 1908-1913       V14672 1914-1918 .2
   V14673 1919-1923       V14674 1924-1928 .2    V14675 1929-1932
   V14676 1933-1936 .2    V14677 1937-1940 .2    V14678 1941
   V14679 1942-1943       V14680 1944-1946       V14681 1947-1948
   V14682 1949            V14683 1950            V14684 1951
   V14685 1952-1953       V14686 1954-1955       V14687 1956
   V14688 1957            V14689 1958            V14690 1959
   V14691 1960            V14692 1961            V14693 1962
   V14694 1963            V14695 1964            V14696 1965
   V14697 1966            V14698 1967            V14699 1968
   V14700 1969            V14701 1970            V14702 1971
   V14703 1972            V14704 1973            V14705 1974-1975
   V14706 1976            V14707 1977-1978       V14708 1979-1981
   V14709 1982            V14710 1983-1986       V14711 1987-1988
   V14712 1989            V14713 1990            V14714 1991
   V14715 1992-1993       V14716 1994-1995       V14717 1996
   V14718 1997            V14719 1998-2001       V14720 2002-2005
   V14721 2006            V14722 2007-2008       V14723 2009-2012
   V14724 2013            V14725 2014-2015       V14726 2016-2019
   V14727 2020            V14728 2021-2022       V14729 2023-2026
   V14730 2027            V14731 2028-2029       V14732 2030-2033
   V14733 2034            V14734 2035            V14735 2036
   V14736 2037            V14737 2038-2039;

* SAS LABEL STATEMENT;

LABEL
   V13701 = "STUDY NUMBER (714)"
   V13702 = "1987 INTERVIEW NUMBER"
   V13703 = "CURRENT STATE"
   V13704 = "CURRENT COUNTY"
   V13705 = "CURRENT STATE+CNTY"
   V13706 = "SIZE LGST CITY/COUNTY 87"
   V13707 = "SPLITOFF INDICATOR    87"
   V13708 = "WHETHER REFUSED       87"
   V13709 = "MODE OF INTERVIEW     87"
   V13710 = "FAM COMP CHANGE       87"
   V13711 = "NUMBER MOVED IN       87"
   V13712 = "WHO MOVED IN          87"
   V13713 = "NUMBER MOVED OUT      87"
   V13714 = "WHO MOVED OUT         87"
   V13715 = "CURRENT FAM COMP      87"
   V13716 = "CURRENT HSEHOLD COMP  87"
   V13717 = "68 ID# OF HOUSEHOLDER 87"
   V13718 = "PERS# OF HOUSEHOLDER  87"
   V13719 = "AGE OF HOUSEHOLDER    87"
   V13720 = "SEX OF HOUSEHOLDER    87"
   V13721 = "REL HHOLDER TO FU HD  87"
   V13722 = "QUALITY OF MATCH      87"
   V13723 = "TYPE INSTITUTION      87"
   V13724 = "1987 HOUSE VALUE   (A10)"
   V13725 = "ACC 87 HOUSE VALUE"
   V13726 = "1987 REM MORT PRIN (A13)"
   V13727 = "ACC REM MORT PRIN"
   V13728 = "1987 ANN MORT PMNT (A15)"
   V13729 = "ACC ANN MORT PAYMENT"
   V13730 = "ANN PROPERTY TAX 87(A11)"
   V13731 = "ACC ANN PROPERTY TAX  87"
   V13732 = "ANN RENT 1987      (A20)"
   V13733 = "ACC ANN RENT 87"
   V13734 = "ANN VALUE IF RENTED(A28)"
   V13735 = "ACC ANN VALUE IF RENTED"
   V13736 = "ANN UTILITIES         87"
   V13737 = "ACC ANN UTIL          87"
   V13738 = "GOVT SUBSIDY OF HTG (A8)"
   V13739 = "HD MAIN JOB WRKHRS 86"
   V13740 = "ACC HD 86 MAIN JOB WRKHR"
   V13741 = "HD OVERTIME WRKHRS 86"
   V13742 = "ACC HD 86 OVERTIME WRKHR"
   V13743 = "HD XTRA JOB WRKHRS 86"
   V13744 = "ACC HD 86 XTRA JOB WRKHR"
   V13745 = "HD ANN WRK HRS IN 86"
   V13746 = "HD HRS WRK LOST OTR ILL"
   V13747 = "ACC HD HR LOST OTR ILL"
   V13748 = "HD HRS WRK LOST OWN ILL"
   V13749 = "ACC HD HRS LOST OWN ILL"
   V13750 = "HD STRIKE HOURS 86"
   V13751 = "ACC HD STRIKE HRS 86"
   V13752 = "HD UNEMP HRS 86"
   V13753 = "ACC 86 HD UNEMP HRS"
   V13754 = "HD HRS OUT LBR FORCE 86"
   V13755 = "ACC 86 HD HR OUT LBR FRC"
   V13756 = "HD UNEMP/OUT LBR JAN 86"
   V13757 = "HD UNEMP/OUT LBR FEB 86"
   V13758 = "HD UNEMP/OUT LBR MAR 86"
   V13759 = "HD UNEMP/OUT LBR APR 86"
   V13760 = "HD UNEMP/OUT LBR MAY 86"
   V13761 = "HD UNEMP/OUT LBR JUN 86"
   V13762 = "HD UNEMP/OUT LBR JUL 86"
   V13763 = "HD UNEMP/OUT LBR AUG 86"
   V13764 = "HD UNEMP/OUT LBR SEP 86"
   V13765 = "HD UNEMP/OUT LBR OCT 86"
   V13766 = "HD UNEMP/OUT LBR NOV 86"
   V13767 = "HD UNEMP/OUT LBR DEC 86"
   V13768 = "HD UNEMP/OUT LBR JAN 87"
   V13769 = "HD UNEMP/OUT LBR FEB 87"
   V13770 = "HD UNEMP/OUT LBR MAR 87"
   V13771 = "HD UNEMP/OUT LBR APR 87"
   V13772 = "HD UNEMP/OUT LBR MAY 87"
   V13773 = "HD UNEMP/OUT LBR JUN 87"
   V13774 = "HD UNEMP/OUT LBR JUL 87"
   V13775 = "HD UNEMP/OUT LBR AUG 87"
   V13776 = "HD UNEMP/OUT LBR SEP 87"
   V13777 = "HD UNEMP/OUT LBR OCT 87"
   V13778 = "HD UNEMPLYD QUALITY CODE"
   V13779 = "HD XTRA JOBS JAN 86"
   V13780 = "HD XTRA JOBS FEB 86"
   V13781 = "HD XTRA JOBS MAR 86"
   V13782 = "HD XTRA JOBS APR 86"
   V13783 = "HD XTRA JOBS MAY 86"
   V13784 = "HD XTRA JOBS JUN 86"
   V13785 = "HD XTRA JOBS JUL 86"
   V13786 = "HD XTRA JOBS AUG 86"
   V13787 = "HD XTRA JOBS SEP 86"
   V13788 = "HD XTRA JOBS OCT 86"
   V13789 = "HD XTRA JOBS NOV 86"
   V13790 = "HD XTRA JOBS DEC 86"
   V13791 = "HD XTRA JOBS JAN 87"
   V13792 = "HD XTRA JOBS FEB 87"
   V13793 = "HD XTRA JOBS MAR 87"
   V13794 = "HD XTRA JOBS APR 87"
   V13795 = "HD XTRA JOBS MAY 87"
   V13796 = "HD XTRA JOBS JUN 87"
   V13797 = "HD XTRA JOBS JUL 87"
   V13798 = "HD XTRA JOBS AUG 87"
   V13799 = "HD XTRA JOBS SEP 87"
   V13800 = "HD XTRA JOBS OCT 87"
   V13801 = "HD XTRA JOB QUALITY CODE"
   V13802 = "WIFE IN FU?"
   V13803 = "WF MAIN JOB WRKHRS 86"
   V13804 = "ACC WF 86 MAIN JOB WRKHR"
   V13805 = "WF OVERTIME WRKHRS 86"
   V13806 = "ACC WF 86 OVERTIME WRKHR"
   V13807 = "WF XTRA JOB WRKHRS 86"
   V13808 = "ACC WF 86 XTRA JOB WRKHR"
   V13809 = "WF ANN WRK HRS IN 86"
   V13810 = "WF HRS WRK LOST OTR ILL"
   V13811 = "ACC WF HR LOST OTR ILL"
   V13812 = "WF HRS WRK LOST OWN ILL"
   V13813 = "ACC WF HRS LOST OWN ILL"
   V13814 = "WF STRIKE HOURS 86"
   V13815 = "ACC WF STRIKE HRS 86"
   V13816 = "WF UNEMP HRS 86"
   V13817 = "ACC WF UNEMP HRS 86"
   V13818 = "WF HRS OUT LBR FORCE 86"
   V13819 = "ACC WF 86 HR OUT LBR FRC"
   V13820 = "WF UNEMP/OUT LBR JAN 86"
   V13821 = "WF UNEMP/OUT LBR FEB 86"
   V13822 = "WF UNEMP/OUT LBR MAR 86"
   V13823 = "WF UNEMP/OUT LBR APR 86"
   V13824 = "WF UNEMP/OUT LBR MAY 86"
   V13825 = "WF UNEMP/OUT LBR JUN 86"
   V13826 = "WF UNEMP/OUT LBR JUL 86"
   V13827 = "WF UNEMP/OUT LBR AUG 86"
   V13828 = "WF UNEMP/OUT LBR SEP 86"
   V13829 = "WF UNEMP/OUT LBR OCT 86"
   V13830 = "WF UNEMP/OUT LBR NOV 86"
   V13831 = "WF UNEMP/OUT LBR DEC 86"
   V13832 = "WF UNEMP/OUT LBR JAN 87"
   V13833 = "WF UNEMP/OUT LBR FEB 87"
   V13834 = "WF UNEMP/OUT LBR MAR 87"
   V13835 = "WF UNEMP/OUT LBR APR 87"
   V13836 = "WF UNEMP/OUT LBR MAY 87"
   V13837 = "WF UNEMP/OUT LBR JUN 87"
   V13838 = "WF UNEMP/OUT LBR JUL 87"
   V13839 = "WF UNEMP/OUT LBR AUG 87"
   V13840 = "WF UNEMP/OUT LBR SEP 87"
   V13841 = "WF UNEMP/OUT LBR OCT 87"
   V13842 = "WF UNEMPLYD QUALITY CODE"
   V13843 = "WF XTRA JOBS JAN 86"
   V13844 = "WF XTRA JOBS FEB 86"
   V13845 = "WF XTRA JOBS MAR 86"
   V13846 = "WF XTRA JOBS APR 86"
   V13847 = "WF XTRA JOBS MAY 86"
   V13848 = "WF XTRA JOBS JUN 86"
   V13849 = "WF XTRA JOBS JUL 86"
   V13850 = "WF XTRA JOBS AUG 86"
   V13851 = "WF XTRA JOBS SEP 86"
   V13852 = "WF XTRA JOBS OCT 86"
   V13853 = "WF XTRA JOBS NOV 86"
   V13854 = "WF XTRA JOBS DEC 86"
   V13855 = "WF XTRA JOBS JAN 87"
   V13856 = "WF XTRA JOBS FEB 87"
   V13857 = "WF XTRA JOBS MAR 87"
   V13858 = "WF XTRA JOBS APR 87"
   V13859 = "WF XTRA JOBS MAY 87"
   V13860 = "WF XTRA JOBS JUN 87"
   V13861 = "WF XTRA JOBS JUL 87"
   V13862 = "WF XTRA JOBS AUG 87"
   V13863 = "WF XTRA JOBS SEP 87"
   V13864 = "WF XTRA JOBS OCT 87"
   V13865 = "WF XTRA JOB QUALITY CODE"
   V13866 = "# MAJOR ADULTS"
   V13867 = "1987 FAMILY SIZE"
   V13868 = "# REQUIRED ROOMS"
   V13869 = "WIFE ANN HOUSEWORK  (F2)"
   V13870 = "ACC WIFE ANN HOUSEWORK"
   V13871 = "HEAD ANN HOUSEWORK  (F3)"
   V13872 = "ACC HEAD ANN HOUSEWORK"
   V13873 = "# PERSONS GOT FOOD STAMP"
   V13874 = "VALUE FD ST LAST MO (F6)"
   V13875 = "ACC VALUE FD ST LAST MO"
   V13876 = "ANN FOOD COST EXC FD ST"
   V13877 = "ACC ANN FD COST EX FD ST"
   V13878 = "ANN COST EAT OUT(F11/15)"
   V13879 = "ACC ANN COST EAT OUT"
   V13880 = "VALUE FD ST 86     (F17)"
   V13881 = "ACC VALUE FD ST 86"
   V13882 = "# MOS USED FD ST 86(F18)"
   V13883 = "WTR USED FD ST JAN 86"
   V13884 = "WTR USED FD ST FEB 86"
   V13885 = "WTR USED FD ST MAR 86"
   V13886 = "WTR USED FD ST APR 86"
   V13887 = "WTR USED FD ST MAY 86"
   V13888 = "WTR USED FD ST JUN 86"
   V13889 = "WTR USED FD ST JUL 86"
   V13890 = "WTR USED FD ST AUG 86"
   V13891 = "WTR USED FD ST SEP 86"
   V13892 = "WTR USED FD ST OCT 86"
   V13893 = "WTR USED FD ST NOV 86"
   V13894 = "WTR USED FD ST DEC 86"
   V13895 = "HD/WF HAVE TXBL Y?"
   V13896 = "LABOR PART FARM Y 86"
   V13897 = "LABOR PART BUS Y 86"
   V13898 = "HEAD 86 WAGES"
   V13899 = "ACC HEAD 86 WAGES"
   V13900 = "HD BONUS/OT/COMM 86"
   V13901 = "HD PROF PRAC/TRADE 86"
   V13902 = "LABOR PT MKT GARDEN 86"
   V13903 = "LABOR PT ROOMERS 86"
   V13904 = "ACC HD LABOR Y EXC WAGES"
   V13905 = "WIFE 86 LABOR/WAGE"
   V13906 = "ACC WF 86 LABOR/WAGE"
   V13907 = "ASSET PART FARM Y 86"
   V13908 = "ASSET PART BUS Y 86"
   V13909 = "ASSET PT MKT GARDN 86"
   V13910 = "ASSET PT ROOMERS 86"
   V13911 = "WF PT ASSET INCOME 86"
   V13912 = "HD # MO RECD RENT 86"
   V13913 = "HD RENT 86"
   V13914 = "HD # MO RECD INT/DIV 86"
   V13915 = "HD INT/DIVIDENDS 86"
   V13916 = "HD #MO RECD ALIMONY 86"
   V13917 = "ALIMONY Y HEAD 86"
   V13918 = "WF 86 OTHER ASSET Y"
   V13919 = "ACC H+W 86 ASSET Y"
   V13920 = "H+W 86 TAXABLE Y"
   V13921 = "H+W 86 SUPP OTR NONFU"
   V13922 = "H+W CHLD SUPPORT PAID 86"
   V13923 = "H+W ALIMONY PAID 86"
   V13924 = "H+W 86 # DEPENDENTS"
   V13925 = "H+W TOTAL 86 EXEMPTION"
   V13926 = "1986 TAX TABLE USED-H+W"
   V13927 = "HD/WF REC TRANSFER Y 86?"
   V13928 = "HD 86 ADC/AFDC"
   V13929 = "ACC HD 86 ADC/AFDC"
   V13930 = "HD # MO RECEIVE SSI 86"
   V13931 = "HD 86 SSI"
   V13932 = "HD 86 OTR WELFARE"
   V13933 = "HD #MO RECD SOC SEC 86"
   V13934 = "HD 86 SOCIAL SECURITY"
   V13935 = "HD TYPE SOC SEC 86"
   V13936 = "HD #MO REC VA PENSION 86"
   V13937 = "HD 86 VA PENSION"
   V13938 = "HD #MO RECD OTR RET 86"
   V13939 = "HD OTHER RETIREMENT 86"
   V13940 = "HD # OTH PENS RCD 86"
   V13941 = "HD 86 UNEMP COMP"
   V13942 = "HD 86 WORKERS COMP"
   V13943 = "HD #MO REC CHILD SUPP 86"
   V13944 = "HD 86 CHILD SUPPORT"
   V13945 = "HD #MO REC HLP FR REL 86"
   V13946 = "HD 86 HELP FROM RELS"
   V13947 = "HD #MO REC OTR TRAN Y 86"
   V13948 = "HD 86 OTHER TRANSFER Y"
   V13949 = "WF 86 ADC/AFDC"
   V13950 = "ACC WF 86 ADC/AFDC"
   V13951 = "WF # MO RECEIVE SSI 86"
   V13952 = "WF 86 SSI"
   V13953 = "WF 86 OTR WELFARE"
   V13954 = "WF #MO RECD SOC SEC 86"
   V13955 = "WF 86 SOCIAL SECURITY"
   V13956 = "WF TYPE SOC SEC 86"
   V13957 = "WF #MO REC VA PENSION 86"
   V13958 = "WF 86 VA PENSION"
   V13959 = "WF #MO RECD OTR RET 86"
   V13960 = "WF OTHER RETIREMENT 86"
   V13961 = "WF 86 UNEMP COMP"
   V13962 = "WF 86 WORKERS COMP"
   V13963 = "WF #MO REC CHILD SUPP 86"
   V13964 = "WF 86 CHILD SUPPORT"
   V13965 = "WF #MO REC HLP FR REL 86"
   V13966 = "WF 86 HELP FROM RELS"
   V13967 = "WF #MO REC OTR TRAN Y 86"
   V13968 = "WF 86 OTHER TRANSFER Y"
   V13969 = "ACC H+W 86 TRANS EXC ADC"
   V13970 = "H+W 86 TOT TRANSFER Y"
   V13971 = "H+W RECD ADC/AFDC JAN 86"
   V13972 = "H+W RECD ADC/AFDC FEB 86"
   V13973 = "H+W RECD ADC/AFDC MAR 86"
   V13974 = "H+W RECD ADC/AFDC APR 86"
   V13975 = "H+W RECD ADC/AFDC MAY 86"
   V13976 = "H+W RECD ADC/AFDC JUN 86"
   V13977 = "H+W RECD ADC/AFDC JUL 86"
   V13978 = "H+W RECD ADC/AFDC AUG 86"
   V13979 = "H+W RECD ADC/AFDC SEP 86"
   V13980 = "H+W RECD ADC/AFDC OCT 86"
   V13981 = "H+W RECD ADC/AFDC NOV 86"
   V13982 = "H+W RECD ADC/AFDC DEC 86"
   V13983 = "H+W REC OTR WELFR JAN 86"
   V13984 = "H+W REC OTR WELFR FEB 86"
   V13985 = "H+W REC OTR WELFR MAR 86"
   V13986 = "H+W REC OTR WELFR APR 86"
   V13987 = "H+W REC OTR WELFR MAY 86"
   V13988 = "H+W REC OTR WELFR JUN 86"
   V13989 = "H+W REC OTR WELFR JUL 86"
   V13990 = "H+W REC OTR WELFR AUG 86"
   V13991 = "H+W REC OTR WELFR SEP 86"
   V13992 = "H+W REC OTR WELFR OCT 86"
   V13993 = "H+W REC OTR WELFR NOV 86"
   V13994 = "H+W REC OTR WELFR DEC 86"
   V13995 = "HD REC UNEMP COMP JAN 86"
   V13996 = "HD REC UNEMP COMP FEB 86"
   V13997 = "HD REC UNEMP COMP MAR 86"
   V13998 = "HD REC UNEMP COMP APR 86"
   V13999 = "HD REC UNEMP COMP MAY 86"
   V14000 = "HD REC UNEMP COMP JUN 86"
   V14001 = "HD REC UNEMP COMP JUL 86"
   V14002 = "HD REC UNEMP COMP AUG 86"
   V14003 = "HD REC UNEMP COMP SEP 86"
   V14004 = "HD REC UNEMP COMP OCT 86"
   V14005 = "HD REC UNEMP COMP NOV 86"
   V14006 = "HD REC UNEMP COMP DEC 86"
   V14007 = "WF REC UNEMP COMP JAN 86"
   V14008 = "WF REC UNEMP COMP FEB 86"
   V14009 = "WF REC UNEMP COMP MAR 86"
   V14010 = "WF REC UNEMP COMP APR 86"
   V14011 = "WF REC UNEMP COMP MAY 86"
   V14012 = "WF REC UNEMP COMP JUN 86"
   V14013 = "WF REC UNEMP COMP JUL 86"
   V14014 = "WF REC UNEMP COMP AUG 86"
   V14015 = "WF REC UNEMP COMP SEP 86"
   V14016 = "WF REC UNEMP COMP OCT 86"
   V14017 = "WF REC UNEMP COMP NOV 86"
   V14018 = "WF REC UNEMP COMP DEC 86"
   V14019 = "HD REC WORKR COMP JAN 86"
   V14020 = "HD REC WORKR COMP FEB 86"
   V14021 = "HD REC WORKR COMP MAR 86"
   V14022 = "HD REC WORKR COMP APR 86"
   V14023 = "HD REC WORKR COMP MAY 86"
   V14024 = "HD REC WORKR COMP JUN 86"
   V14025 = "HD REC WORKR COMP JUL 86"
   V14026 = "HD REC WORKR COMP AUG 86"
   V14027 = "HD REC WORKR COMP SEP 86"
   V14028 = "HD REC WORKR COMP OCT 86"
   V14029 = "HD REC WORKR COMP NOV 86"
   V14030 = "HD REC WORKR COMP DEC 86"
   V14031 = "WF REC WRKR COMP JAN 86"
   V14032 = "WF REC WRKR COMP FEB 86"
   V14033 = "WF REC WRKR COMP MAR 86"
   V14034 = "WF REC WRKR COMP APR 86"
   V14035 = "WF REC WRKR COMP MAY 86"
   V14036 = "WF REC WRKR COMP JUN 86"
   V14037 = "WF REC WRKR COMP JUL 86"
   V14038 = "WF REC WRKR COMP AUG 86"
   V14039 = "WF REC WRKR COMP SEP 86"
   V14040 = "WF REC WRKR COMP OCT 86"
   V14041 = "WF REC WRKR COMP NOV 86"
   V14042 = "WF REC WRKR COMP DEC 86"
   V14043 = "OFUM REC TXBL Y 86?"
   V14044 = "SEQ# 1ST OFUM W TXBL Y"
   V14045 = "P PRORAT TXBL Y 1ST OFUM"
   V14046 = "TXBL Y 1ST XTRA EARNER"
   V14047 = "# EXEMP 1ST XTRA EARNER"
   V14048 = "TAX TABLE 1ST XTRA EARNR"
   V14049 = "SEQ# 2ND OFUM W TXBL Y"
   V14050 = "P PRORAT TXBL Y 2ND OFUM"
   V14051 = "TXBL Y 2ND XTRA EARNER"
   V14052 = "# EXEMP 2ND XTRA EARNER"
   V14053 = "TAX TABLE 2ND XTRA EARNR"
   V14054 = "SEQ# 3RD OFUM W TXBL Y"
   V14055 = "P PRORAT TXBL Y 3RD OFUM"
   V14056 = "TXBL Y 3RD XTRA EARNER"
   V14057 = "# EXEMP 3RD XTRA EARNER"
   V14058 = "TAX TABLE 3RD XTRA EARNR"
   V14059 = "SEQ# 4TH OFUM W TXBL Y"
   V14060 = "P PRORAT TXBL Y 4TH OFUM"
   V14061 = "TXBL Y 4TH XTRA EARNER"
   V14062 = "# EXEMP 4TH XTRA EARNER"
   V14063 = "TAX TABLE 4TH XTRA EARNR"
   V14064 = "SEQ# 5TH OFUM W TXBL Y"
   V14065 = "P PRORAT TXBL Y 5TH OFUM"
   V14066 = "TXBL Y 5TH XTRA EARNER"
   V14067 = "# EXEMP 5TH XTRA EARNER"
   V14068 = "TAX TABLE 5TH XTRA EARNR"
   V14069 = "OFUM 86 ANN WRK HRS"
   V14070 = "OFUM 86 TOT ANN TXBL Y"
   V14071 = "ACC OFUM ANN TXBL Y 86"
   V14072 = "OFUM 86 ASSET Y"
   V14073 = "OFUM REC TRANSFER Y?"
   V14074 = "OFUM 86 ADC/AFDC"
   V14075 = "OFUM 86 SSI"
   V14076 = "OFUM 86 OTHER WELFARE"
   V14077 = "OFUM 86 SOC SECURITY"
   V14078 = "OFUM 86 VA PAYMENTS"
   V14079 = "OFUM 86 OTR RETIREMENT"
   V14080 = "OFUM 86 UNEMP COMP"
   V14081 = "OFUM 86 WORKERS COMP"
   V14082 = "OFUM 86 CHILD SUPPORT"
   V14083 = "OFUM 86 HELP FROM RELS"
   V14084 = "OFUM 86 OTHER TRANSFERS"
   V14085 = "NOPRO TOT TRANS Y OFUM86"
   V14086 = "PRO TOT TRANS Y OFUM 86"
   V14087 = "ACC OFUM 86 TRANSFERS"
   V14088 = "# OFUM Y RECEIVERS 86"
   V14089 = "# OFUM LABOR Y RECRS 86"
   V14090 = "1968 ID"
   V14091 = "1969 ID"
   V14092 = "1970 ID"
   V14093 = "1971 ID"
   V14094 = "1972 ID"
   V14095 = "1973 ID"
   V14096 = "1974 ID"
   V14097 = "1975 ID"
   V14098 = "1976 ID"
   V14099 = "1977 ID"
   V14100 = "1978 ID"
   V14101 = "1979 ID"
   V14102 = "1980 ID"
   V14103 = "1981 ID"
   V14104 = "1982 ID"
   V14105 = "1983 ID"
   V14106 = "1984 ID"
   V14107 = "1985 ID"
   V14108 = "1986 ID"
   V14109 = "INTERVIEWER ID # 1987"
   V14110 = "INTERVIEWER IN #"
   V14111 = "DATE OF 1987 IW"
   V14112 = "LENGTH OF 1987 IW"
   V14113 = "# IN FU"
   V14114 = "AGE OF 1987 HEAD"
   V14115 = "SEX OF 1987 HEAD"
   V14116 = "AGE OF 1987 WIFE"
   V14117 = "# CHILDREN IN FU"
   V14118 = "AGE YOUNGEST CHILD"
   V14119 = "# NONFU SHARING HU"
   V14120 = "A3 MARITAL STATUS"
   V14121 = "A4 TYPE DU"
   V14122 = "A5 ACTUAL # ROOMS"
   V14123 = "A6 TYPE FUEL FOR HEAT:1"
   V14124 = "A6 TYPE FUEL FOR HEAT:2"
   V14125 = "A7 RECD GOVT HTG SUBSDY"
   V14126 = "A9 OWN/RENT OR WHAT"
   V14127 = "A12 HAVE MORTGAGE?"
   V14128 = "A16 # YRS PAY ON MORT?"
   V14129 = "A17 SECOND MORTGAGE?"
   V14130 = "A18 PROP TAX IN MTG PMT?"
   V14131 = "A21 RENTED FURNISHED?"
   V14132 = "A22 IN PUBLIC OWND PROJ?"
   V14133 = "A23 GOVT PAY PART RENT?"
   V14134 = "A24 PAY HEAT/ELEC/WATER?"
   V14135 = "A26 HEAT IN MTHLY RENT?"
   V14136 = "A27 WHY NOT OWN/RENT"
   V14137 = "A29 IN PUBLIC OWND PROJ?"
   V14138 = "A30 GOVT PAY ALL RENT?"
   V14139 = "A31 PAY HEAT/ELEC/WATER?"
   V14140 = "A33 MOVED SINCE SPG 86?"
   V14141 = "A34 MONTH MOVED"
   V14142 = "A35 WHY MOVED"
   V14143 = "A36 WTR MIGHT MOVE"
   V14144 = "A37 LIKELIHOOD OF MOVING"
   V14145 = "A38 WHY MIGHT MOVE"
   V14146 = "B1 EMPLMT STATUS-HEAD"
   V14147 = "B2 YEAR RETIRED   (HD-R)"
   V14148 = "B3 WORK FOR MONEY?(HD-E)"
   V14149 = "B4 WORK SELF/OTR? (HD-E)"
   V14150 = "B5 CORP/UNCORP BUS(HD-E)"
   V14151 = "B6 WORK FOR GOVT? (HD-E)"
   V14152 = "B7 JOB NOW UNION?  (H-E)"
   V14153 = "B8 BELONG UNION?  (HD-E)"
   V14154 = "B9-10 MAIN OCC:3 DIG H-E"
   V14155 = "B11 MAIN IND:3 DIGT(H-E)"
   V14156 = "B12 SLRY/HRLY/OTR  (H-E)"
   V14157 = "B13 PAY/HR-SALARY (HD-E)"
   V14158 = "B14 WTR SAL PD OT (HD-E)"
   V14159 = "B15 PAY/HR-SLRYOT (HD-E)"
   V14160 = "B16 PAY/HR-HOURLY (HD-E)"
   V14161 = "B17 PAY/HR-HRLY OT (H-E)"
   V14162 = "B18 HOW PAID-OTR  (HD-E)"
   V14163 = "B19 PAY/HR-OTR OT  (H-E)"
   V14164 = "B20 GET NEW JOB?  (HD-E)"
   V14165 = "B21 WHAT DO-NEW JOB(H-E)"
   V14166 = "B23 #MO PRESENT EMP(H-E)"
   V14167 = "B24 #MO PRESENT POS(H-E)"
   V14168 = "B24 MO ST PRES POS(HD-E)"
   V14169 = "B24 YR ST PRES POS(HD-E)"
   V14170 = "B25 POS TO BE PERM?(H-E)"
   V14171 = "B26 STARTING WAGE (HD-E)"
   V14172 = "B27 HR/WK WORKED  (HD-E)"
   V14173 = "B28 ONLY JOB OPP? (HD-E)"
   V14174 = "B29 EMP BEFORE NOW?(H-E)"
   V14175 = "B30 WRKG BEFORE NOW? H-E"
   V14176 = "B31 WRKG SAME EMP? (H-E)"
   V14177 = "B32 WHY LFT PREV POS H-E"
   V14178 = "B33 MO PREV POS END(H-E)"
   V14179 = "B33 YR PREV POS END(H-E)"
   V14180 = "B35 WRK GOV-PREV POS?H-E"
   V14181 = "B36 PREV INDUSTRY (HD-E)"
   V14182 = "B37-38 PREV OCC    (H-E)"
   V14183 = "B39 PREV END WAGE  (H-E)"
   V14184 = "B40 PREV END HR/WK (H-E)"
   V14185 = "B41 MO ST PREV JOB(HD-E)"
   V14186 = "B41 YR ST PREV JOB(HD-E)"
   V14187 = "B42 POS TO BE PERM?(H-E)"
   V14188 = "B43 PREV START WAGE(H-E)"
   V14189 = "B44 PREV START HR/WK H-E"
   V14190 = "B-WHE WORK HIST SUPP H-E"
   V14191 = "B45 WTR OTRS ILL  (HD-E)"
   V14192 = "B46 # WKS OTR ILL (HD-E)"
   V14193 = "B48 WTR SELF ILL  (HD-E)"
   V14194 = "B49 # WKS SELF ILL(HD-E)"
   V14195 = "B51 WTR VACATION  (HD-E)"
   V14196 = "B52 # WK VACATION (HD-E)"
   V14197 = "B54 WTR STRIKE    (HD-E)"
   V14198 = "B55 # WK ON STRIKE (H-E)"
   V14199 = "B57 WTR UNEMPLOYED(HD-E)"
   V14200 = "B58 # WK UNEMPLOYED(H-E)"
   V14201 = "B60 WTR OUT LAB FRC(H-E)"
   V14202 = "B61 #WK OUT LAB FRC(H-E)"
   V14203 = "B63 # WKS WORKED  (HD-E)"
   V14204 = "B64 # HR/WK WORKED (H-E)"
   V14205 = "B65 WTR WORKED OT (HD-E)"
   V14206 = "B67 WTR XTRA JOBS (HD-E)"
   V14207 = "B67-74 # XTRA JOBS (H-E)"
   V14208 = "B68 OCC-XTRA JOB1 (HD-E)"
   V14209 = "B70 PAY/HR XTRA JB1(H-E)"
   V14210 = "B71 # WKS XTRA JOB1(H-E)"
   V14211 = "B73 HR/WK XTRA JOB1(H-E)"
   V14212 = "B68 OCC-XTRA JOB2 (HD-E)"
   V14213 = "B70 AV PY/HR X JB2+(H-E)"
   V14214 = "B71 #WKS XTRA JOB2+(H-E)"
   V14215 = "B73 AV HR/WK X JB2+(H-E)"
   V14216 = "B75 WTR UNEMP 87   (H-E)"
   V14217 = "B76 # WK UNEMP 87  (H-E)"
   V14218 = "B78 OUT LAB FRC 87?(H-E)"
   V14219 = "B79 # WK OUT LF 87 (H-E)"
   V14220 = "B81 # WKS WORKED 87(H-E)"
   V14221 = "B83 # HR/WK WRKD 87 H-E"
   V14222 = "B84 WTR XTRA JOB 87(H-E)"
   V14223 = "B84-90 #XTRA JBS 87(H-E)"
   V14224 = "B85 OCC-XTRA JOB1 (HD-E)"
   V14225 = "B87 # WKS XTRA JOB1(H-E)"
   V14226 = "B89 HR/WK XTRA JOB (H-E)"
   V14227 = "B85 OCC-XTRA JOB2+(HD-E)"
   V14228 = "B87 #WKS XTRA JOB2+(H-E)"
   V14229 = "B89 AV HR/WK X JOB2+ H-E"
   V14230 = "B91 WTR MORE WORK  (H-E)"
   V14231 = "B92 PAY/HR MORE WORK H-E"
   V14232 = "B93 COULD WORK LESS(H-E)"
   V14233 = "B94 WANT WORK LESS?(H-E)"
   V14234 = "B95 WANT WORK MORE?(H-E)"
   V14235 = "B96 COULD WORK LESS(H-E)"
   V14236 = "B97 WANT WRK LESS? (H-E)"
   V14237 = "C1 WTR LOOK FOR JOB(H-U)"
   V14238 = "C2 # PLACES LOOKED (H-U)"
   V14239 = "C3 OCC-JOB SOUGHT (HD-U)"
   V14240 = "C4 WTR NEED TRAING (H-U)"
   V14241 = "C5 RESERVATION WAGE HD-U"
   V14242 = "C6 #WKS LOOK WORK (HD-U)"
   V14243 = "C7 JOB IN FUTURE?  (H-U)"
   V14244 = "C8 WHEN GET JOB   (HD-U)"
   V14245 = "C9 EVER WORKED?   (HD-U)"
   V14246 = "C10 MO JOB ENDED  (HD-U)"
   V14247 = "C10 YR JOB ENDED  (HD-U)"
   V14248 = "C11 WTR UNEMP 86   (H-U)"
   V14249 = "C12 # WK UNEMP 86  (H-U)"
   V14250 = "C14 WTR UNEMP 87   (H-U)"
   V14251 = "C15 # WK UNEMP 87  (H-U)"
   V14252 = "C17-18 OCC-LAST JOB(H-U)"
   V14253 = "C19 IND-LAST JOB  (HD-U)"
   V14254 = "C20 WRK SELF/OTR? (HD-U)"
   V14255 = "C21 WORK FOR GOVT? (H-U)"
   V14256 = "C22 WHY LAST POS END H-U"
   V14257 = "C23 MO LAST POS END(H-U)"
   V14258 = "C23 YR LAST POS END(H-U)"
   V14259 = "C24 LAST END WAGE (HD-U)"
   V14260 = "C25 HR/WK LAST JOB (H-U)"
   V14261 = "C26 MO ST LAST POS (H-U)"
   V14262 = "C26 YR ST LAST POS (H-U)"
   V14263 = "C27 POS TO BE PERM?(H-U)"
   V14264 = "C28 LAST START WAGE(H-U)"
   V14265 = "C29 LAST START HR/WK H-U"
   V14266 = "C30 EMP BEFORE THEN? H-U"
   V14267 = "C31 WRK BEFORE THEN? H-U"
   V14268 = "C32 WRKG SAME EMP? (H-U)"
   V14269 = "C33 MO PREV POS END(H-U)"
   V14270 = "C33 YR PREV POS END(H-U)"
   V14271 = "C35 WRK GOV-PREV POS?H-U"
   V14272 = "C36 PREV INDUSTRY (HD-U)"
   V14273 = "C37-38 PREV OCC    (H-U)"
   V14274 = "C39 PREV END WAGE (HD-U)"
   V14275 = "C40 PREV END HR/WK(HD-U)"
   V14276 = "C41 MO ST PREV POS(HD-U)"
   V14277 = "C41 YR ST PREV POS(HD-U)"
   V14278 = "C42 POS TO BE PERM?(H-U)"
   V14279 = "C43 PREV START WAGE(H-U)"
   V14280 = "C44 PREV START HR/WK H-U"
   V14281 = "C-WHE WORK HIST SUPP H-U"
   V14282 = "C45 WTR VACATION  (HD-U)"
   V14283 = "C46 #WKS VACATION (HD-U)"
   V14284 = "C48 WTR OTRS ILL  (HD-U)"
   V14285 = "C49 #WKS OTRS ILL (HD-U)"
   V14286 = "C51 WTR SELF ILL  (HD-U)"
   V14287 = "C52 #WKS SELF ILL (HD-U)"
   V14288 = "C54 WTR ON STRIKE (HD-U)"
   V14289 = "C55 #WKS ON STRIKE (H-U)"
   V14290 = "C57 WTR UNEMPLOYED (H-U)"
   V14291 = "C58 #WK UNEMPLOYED (H-U)"
   V14292 = "C60 WTR OUT LAB FRC(H-U)"
   V14293 = "C61 #WKS OUT LAB FRC H-U"
   V14294 = "C63 # WKS WORKED  (HD-U)"
   V14295 = "C64 HR/WK WORKED  (HD-U)"
   V14296 = "C65 WTR XTRA JOBS (HD-U)"
   V14297 = "C65-72 # XTRA JOBS (H-U)"
   V14298 = "C66 OCC-XTRA JOB1 (HD-U)"
   V14299 = "C68 PAY/HR XTRA JOB1 H-U"
   V14300 = "C69 # WKS EXTRA JOB1 H-U"
   V14301 = "C71 HR/WK XTRA JOB1(H-U)"
   V14302 = "C66-67 OCC-XTRA JB2(H-U)"
   V14303 = "C68 AV PY/HR X JB2+(H-U)"
   V14304 = "C69 # WK XTRA JOB2+(H-U)"
   V14305 = "C71 AV HR/WK X JB2+(H-U)"
   V14306 = "C73 WTR UNEMP 87   (H-U)"
   V14307 = "C74 # WK UNEMP 87  (H-U)"
   V14308 = "C76 OUT LAB FRC 87?(H-U)"
   V14309 = "C77 # WK OUT LF 87 (H-U)"
   V14310 = "C79 # WKS WORKED 87(H-E)"
   V14311 = "C81 HR/WK WRKD 87  (H-E)"
   V14312 = "C82 WTR XTRA JOB 87(H-U)"
   V14313 = "C82-88 #XTRA JBS 87(H-U)"
   V14314 = "C83-84 OCC-XTRA JOB(H-U)"
   V14315 = "C85 # WKS EXTRA JOB1 H-U"
   V14316 = "C87 HR/WK XTRA JOB1(H-U)"
   V14317 = "C83-84 OCC-XTRA JOB2 H-U"
   V14318 = "C85 # WK XTRA JOB2+(H-U)"
   V14319 = "C87 AV HR/WK X JB2+(H-U)"
   V14320 = "D1A CKPT:WIFE IN FU-WIFE"
   V14321 = "D1B EMPLMT STATUS-WIFE"
   V14322 = "D2 YEAR RETIRED   (WF-E)"
   V14323 = "D3 WORK FOR MONEY?(WF-E)"
   V14324 = "D4 WORK SELF/OTR? (WF-E)"
   V14325 = "D5 CORP/UNCORP BUS(WF-E)"
   V14326 = "D6 WORK FOR GOVT? (WF-E)"
   V14327 = "D7 JOB NOW UNION?  (W-E)"
   V14328 = "D8 BELONG UNION?  (WF-E)"
   V14329 = "D9-10 MAIN OCC:3 DIG W-E"
   V14330 = "D11 MAIN IND:3 DIGT(W-E)"
   V14331 = "D12 SLRY/HRLY/OTR  (W-E)"
   V14332 = "D13 PAY/HR-SALARY (WF-E)"
   V14333 = "D14 WTR SAL PD OT (WF-E)"
   V14334 = "D15 PAY/HR-SLRYOT (WF-E)"
   V14335 = "D16 PAY/HR-HOURLY (WF-E)"
   V14336 = "D17 PAY/HR-HRLY OT (W-E)"
   V14337 = "D18 HOW PAID-OTR  (WF-E)"
   V14338 = "D19 PAY/HR-OTR OT  (W-E)"
   V14339 = "D21 #MO PRESENT EMP(W-E)"
   V14340 = "D22 #MO PRESENT POS(W-E)"
   V14341 = "D22 MO ST PRES POS(WF-E)"
   V14342 = "D22 YR ST PRES POS(WF-E)"
   V14343 = "D23 POS TO BE PERM?(W-E)"
   V14344 = "D24 STARTING WAGE (WF-E)"
   V14345 = "D25 HR/WK WORKED  (WF-E)"
   V14346 = "D26 ONLY JOB OPP? (WF-E)"
   V14347 = "D27 EMP BEFORE NOW?(W-E)"
   V14348 = "D28 WRKG BEFORE NOW? W-E"
   V14349 = "D29 WRKG SAME EMP? (W-E)"
   V14350 = "D30 WHY LFT PREV POS W-E"
   V14351 = "D31 MO PREV POS END(W-E)"
   V14352 = "D31 YR PREV POS END(W-E)"
   V14353 = "D33 WRK GOV-PREV POS W-E"
   V14354 = "D34 PREV INDUSTRY (WF-E)"
   V14355 = "D35-36 PREV OCC    (W-E)"
   V14356 = "D37 PREV END WAGE (WF-E)"
   V14357 = "D38 PREV END HR/WK (W-E)"
   V14358 = "D39 MO ST PREV JOB(WF-E)"
   V14359 = "D39 YR ST PREV JOB(WF-E)"
   V14360 = "D40 POS TO BE PERM?(W-E)"
   V14361 = "D41 PREV START WAGE(W-E)"
   V14362 = "D42 PREV START HR/WK W-E"
   V14363 = "D-WHE WORK HIST SUPP W-E"
   V14364 = "D43 WTR OTRS ILL  (WF-E)"
   V14365 = "D44 # WKS OTR ILL (WF-E)"
   V14366 = "D46 WTR SELF ILL  (WF-E)"
   V14367 = "D47 # WKS SELF ILL(WF-E)"
   V14368 = "D49 WTR VACATION  (WF-E)"
   V14369 = "D50 # WK VACATION (WF-E)"
   V14370 = "D52 WTR STRIKE    (WF-E)"
   V14371 = "D53 # WK ON STRIKE (W-E)"
   V14372 = "D55 WTR UNEMPLOYED(WF-E)"
   V14373 = "D56 # WK UNEMPLYED(WF-E)"
   V14374 = "D58 WTR OUT LAB FRC(W-E)"
   V14375 = "D59 #WK OUT LAB FRC(W-E)"
   V14376 = "D61 # WKS WORKED  (WF-E)"
   V14377 = "D62 # HR/WK WRKD  (WF-E)"
   V14378 = "D63 WTR WORKED OT (WF-E)"
   V14379 = "D65 WTR XTRA JOBS (WF-E)"
   V14380 = "D65-72 # XTRA JOBS (W-E)"
   V14381 = "D66 OCC-XTRA JOB1 (WF-E)"
   V14382 = "D68 PAY/HR XTRA JB1(W-E)"
   V14383 = "D69 # WKS XTRA JOB1(W-E)"
   V14384 = "D71 HR/WK XTRA JOB1(W-E)"
   V14385 = "D66 OCC-XTRA JOB2 (WF-E)"
   V14386 = "D68 AV PY/HR X JB2+(W-E)"
   V14387 = "D69 #WKS XTRA JOB2+(W-E)"
   V14388 = "D71 AV HR/WK X JB2+(W-E)"
   V14389 = "D73 WTR UNEMP 87   (W-E)"
   V14390 = "D74 # WK UNEMPLOYED(W-E)"
   V14391 = "D76 OUT LAB FRC 87?(W-E)"
   V14392 = "D77 # WK OUT LF 87 (W-E)"
   V14393 = "D79 # WK WORKED 87 (W-E)"
   V14394 = "D81 # HR/WK WRKD 87(W-E)"
   V14395 = "D82 WTR XTRA JOB 87(W-E)"
   V14396 = "D82-88 #XTRA JBS 87(W-E)"
   V14397 = "D83 OCC-XTRA JOB1 (WF-E)"
   V14398 = "D85 # WKS XTRA JOB1(W-E)"
   V14399 = "D87 HR/WK XTRA JOB (W-E)"
   V14400 = "D83 OCC-XTRA JOB2+(WF-E)"
   V14401 = "D85 #WKS XTR JOB2+ (W-E)"
   V14402 = "D87 AV HR/WK X JOB2+ W-E"
   V14403 = "E1 WTR LOOK FOR JOB(W-U)"
   V14404 = "E2 # PLACES LOOKED (W-U)"
   V14405 = "E3 OCC-JOB SOUGHT (WF-U)"
   V14406 = "E4 WTR NEED TRAING (W-U)"
   V14407 = "E5 # WKS LOOK WORK (W-U)"
   V14408 = "E6 JOB IN FUTURE?  (W-U)"
   V14409 = "E7 EVER WORKED?   (WF-U)"
   V14410 = "E8 MO JOB ENDED   (WF-U)"
   V14411 = "E8 YR JOB ENDED   (WF-U)"
   V14412 = "E9 WTR UNEMP 86    (W-U)"
   V14413 = "E10 # WK UNEMP 86  (W-U)"
   V14414 = "E12 WTR UNEMP 87   (W-U)"
   V14415 = "E13 # WK UNEMP 87  (W-U)"
   V14416 = "E15-16 OCC-LAST JOB(W-U)"
   V14417 = "E17 IND-LAST JOB  (WF-U)"
   V14418 = "E18 WORK SELF/OTR?(WF-U)"
   V14419 = "E19 WORK FOR GOVT? (W-U)"
   V14420 = "E20 WHY LAST POS END W-U"
   V14421 = "E21 MO LAST POS END(W-U)"
   V14422 = "E21 YR LAST POS END(W-U)"
   V14423 = "E22 LAST END WAGE (WF-U)"
   V14424 = "E23 HR/WK LAST JOB (W-U)"
   V14425 = "E24 MO ST LAST POS (W-U)"
   V14426 = "E24 YR ST LAST POS (W-U)"
   V14427 = "E25 POS TO BE PERM?(W-U)"
   V14428 = "E26 LAST START WAGE(W-U)"
   V14429 = "E27 LAST START HR/WK W-U"
   V14430 = "E28 EMP BEFORE THEN? W-U"
   V14431 = "E29 WRK BEFORE THEN? W-U"
   V14432 = "E30 WRKG SAME EMP? (W-U)"
   V14433 = "E31 MO PREV POS END(W-U)"
   V14434 = "E31 YR PREV POS END(W-U)"
   V14435 = "E33 WRK GOV-PREV POS?W-U"
   V14436 = "E34 PREV INDUSTRY (WF-U)"
   V14437 = "E35-36 PREV OCC    (W-U)"
   V14438 = "E37 PREV END WAGE (WF-U)"
   V14439 = "E38 PREV END HR/WK (W-U)"
   V14440 = "E39 MO ST PREV POS(WF-U)"
   V14441 = "E39 YR ST PREV POS(WF-U)"
   V14442 = "E40 POS TO BE PERM?(W-U)"
   V14443 = "E41 PREV START WAGE(W-U)"
   V14444 = "E42 PREV START HR/WK W-U"
   V14445 = "E-WHE WORK HIST SUPP W-U"
   V14446 = "E43 WTR VACATION  (WF-U)"
   V14447 = "E44 #WKS VACATION (WF-U)"
   V14448 = "E46 WTR OTRS ILL  (WF-U)"
   V14449 = "E47 #WKS OTRS ILL (WF-U)"
   V14450 = "E49 WTR SELF ILL  (WF-U)"
   V14451 = "E50 #WKS SELF ILL (WF-U)"
   V14452 = "E52 WTR ON STRIKE (WF-U)"
   V14453 = "E53 #WKS ON STRIKE (W-U)"
   V14454 = "E55 WTR UNEMPLOYED(WF-U)"
   V14455 = "E56 #WKS UNEMPLYD (WF-U)"
   V14456 = "E58 WTR OUT LAB FRC(W-U)"
   V14457 = "E59 #WKS OUT LAB FRC W-U"
   V14458 = "E61 #WKS WORKED   (WF-U)"
   V14459 = "E62 HR/WK WORKED  (WF-U)"
   V14460 = "E63 WTR XTRA JOBS (WF-U)"
   V14461 = "E63-70 # XTRA JOBS (W-U)"
   V14462 = "E64-65 OCC-XTRA JB1 WF-U"
   V14463 = "E66 PAY/HR XTRA JOB(W-U)"
   V14464 = "E67 # WKS XTRA JOB1(W-U)"
   V14465 = "E69 HR/WK XTRA JOB1(W-U)"
   V14466 = "E64-65 OCC-XTRA JB2(W-U)"
   V14467 = "E66 AV PY/HR X JB2+(W-U)"
   V14468 = "E67 # WK XTRA JOB2+(W-U)"
   V14469 = "E69 AV HR/WK X JB2+(W-U)"
   V14470 = "E71 WTR UNEMP 87   (W-U)"
   V14471 = "E72 # WK UNEMP 87  (W-U)"
   V14472 = "E74 WTR OUT LF 87? (W-U)"
   V14473 = "E75 # WK OUT LF 87 (W-U)"
   V14474 = "E77 # WKS WORKED 87(W-U)"
   V14475 = "E79 HR/WK WORKED 87(W-U)"
   V14476 = "E80 WTR XTRA JOB 87(W-U)"
   V14477 = "E80-86 # XTRA JBS 87 W-U"
   V14478 = "E81-82 OCC-XTRA JOB1 W-U"
   V14479 = "E83 # WKS XTRA JOB1(W-U)"
   V14480 = "E85 HR/WK XTRA JOB1(W-U)"
   V14481 = "E81-82 OCC-XTRA JOB2 W-U"
   V14482 = "E83 # WK XTRA JOB2+(W-U)"
   V14483 = "E85 AV HR/WK X JB2+(W-U)"
   V14484 = "F1 CKPT:TYPE HEAD+WIFE"
   V14485 = "F2 HOUSEWORK HRS-WIFE"
   V14486 = "F3 HOUSEWORK HOURS-HEAD"
   V14487 = "F20 ELIG FOR FD STMPS 86"
   V14488 = "F21 TRY GET FOOD STMP 86"
   V14489 = "F22 WHY NOT GET FD STMPS"
   V14490 = "F23 NOT TRY FD STMPS1 86"
   V14491 = "F23 NOT TRY FD STMPS2 86"
   V14492 = "F24 WHY NOT ELIG FDSTMP1"
   V14493 = "F24 WHY NOT ELIG FDSTMP2"
   V14494 = "G2 WHETHER HEAD FARMER"
   V14495 = "G3 TOTAL FARM RECEIPTS"
   V14496 = "G6 WHETHER BUSINESS"
   V14497 = "G7 TYPE BUS HAVE INT IN"
   V14498 = "G8 WHO IN FAM OWNED BUS"
   V14499 = "G9 R PUT TIME IN BUS 86?"
   V14500 = "G10 CORP/UNINCORP BUS"
   V14501 = "G99 WTR LUMP SUM PAYMNTS"
   V14502 = "G100 LUMP SUM PAYMNTS"
   V14503 = "G101 WTR ITEM 86 TAX DED"
   V14504 = "G102 WTR HELP SUPPORT OT"
   V14505 = "G103 # OTHERS SUPPORTED"
   V14506 = "G104 WHO SUPPORTED #1"
   V14507 = "G104 WHO SUPPORTED #2"
   V14508 = "G104 WHO SUPPORTED #3"
   V14509 = "G106 PAY CHILD SUPP 86"
   V14510 = "G108 PAY ALIMONY 86"
   V14511 = "G111/G113 OTR DEPEND"
   V14512 = "G112 # OTHER DEPENDENTS"
   V14513 = "H1 STATUS OF HEALTH-HEAD"
   V14514 = "H2 HEALTH VS 2 YRS AGO"
   V14515 = "H3 LIMIT TYPE/AMT WRK  H"
   V14516 = "H4 NOT DO CERTAIN WRK  H"
   V14517 = "H5 LIMIT AMT WRK DO    H"
   V14518 = "H6 IN HOSPITAL 1986?   H"
   V14519 = "H7 # NIGHTS IN HOSP    H"
   V14520 = "H8 HAVE MEDICAID,ETC?"
   V14521 = "H9 IWCKPT # FU"
   V14522 = "H10 OFUM REC MED AID? 87"
   V14523 = "H12 IWCKPT-W/'W' IN FU?"
   V14524 = "H13 STATUS OF HLTH-WIFE"
   V14525 = "H14 HLTH VS 2 YRS AGO  W"
   V14526 = "H15 LIMIT TYPE/AMT WRK W"
   V14527 = "H16 NOT DO CERTAIN WRK W"
   V14528 = "H17 LIMIT AMT WORK DO  W"
   V14529 = "H18 IN HOSPITAL 1986?  W"
   V14530 = "H19 # NIGHTS IN HOSP   W"
   V14531 = "K1 CKPT: WTR WIFE"
   V14532 = "K2-3 EDUC OF FATHER   WF"
   V14533 = "K4-5 EDUC OF MOTHER   WF"
   V14534 = "K6 WHETHER BROTHERS   WF"
   V14535 = "K7 # BROTHERS       WIFE"
   V14536 = "K8 ONLY BRO STILL ALIVE"
   V14537 = "K9 ONLY BRO OLDR THAN W"
   V14538 = "K10 # BRO STILL ALIVE"
   V14539 = "K11 ANY BRO OLDR THAN WF"
   V14540 = "K12 WHETHER SISTERS   WF"
   V14541 = "K13 # SISTERS       WIFE"
   V14542 = "K14 ONLY SIS STILL ALIVE"
   V14543 = "K15 ONLY SIS OLDR THAN W"
   V14544 = "K16 # SIS STILL ALIVE"
   V14545 = "K17 ANY SIS OLDR THAN WF"
   V14546 = "K18 SPANISH DESCENT   WF"
   V14547 = "K19 RACE OF WIFE 1"
   V14548 = "K19 RACE OF WIFE 2"
   V14549 = "K20 WTR IN MILIT SERV  W"
   V14550 = "K21 WTR GRADUATED HS  WF"
   V14551 = "K22 YR GRADUATED HS   WF"
   V14552 = "K23 GRADE LEVEL IF GED W"
   V14553 = "K24 YR LAST IN SCH-GED W"
   V14554 = "K25 YR RECEIVED GED   WF"
   V14555 = "K26 GRD OF SCH FINISH  W"
   V14556 = "K27 YR LAST IN SCH-NONGR"
   V14557 = "K28 WTR ATTEND COLLEGE W"
   V14558 = "K29 YR LAST ATTEND COLL"
   V14559 = "K30 HGHST YR COLL COMP W"
   V14560 = "K31 WTR RECD COLL DEG  W"
   V14561 = "K32 HGHST COLL DEG REC W"
   V14562 = "K35 YR RECD COLL DEG   W"
   V14563 = "K36 WTR REC OTR DEG/CERT"
   V14564 = "K36 # OTR DEG/CERT REC"
   V14565 = "K37 TYPE OTR DEG/CERT 1"
   V14566 = "K38 FIELD OF DEG/CERT 1"
   V14567 = "K39 INST/ORG DEG/CERT 1"
   V14568 = "K40 YR REC DEG/CERT 1"
   V14569 = "K37 TYPE OTR DEG/CERT 2"
   V14570 = "K38 FIELD OF DEG/CERT 2"
   V14571 = "K39 INST/ORG DEG/CERT 2"
   V14572 = "K40 YR REC DEG/CERT 2"
   V14573 = "K37 TYPE OTR DEG/CERT 3"
   V14574 = "K38 FIELD OF DEG/CERT 3"
   V14575 = "K39 INST/ORG DEG/CERT 3"
   V14576 = "K40 YR REC DEG/CERT 3"
   V14577 = "K42-43 RELIGIOUS PREF  W"
   V14578 = "K44 #YRS WRKD SINCE 18 W"
   V14579 = "K45 #YR WRKD FULL-TIME W"
   V14580 = "L1 CKPT: WTR NEW HEAD"
   V14581 = "L2 STATE FA GREW UP   HD"
   V14582 = "L2 CNTY FA GREW UP    HD"
   V14583 = "L3 STATE MO GREW UP   HD"
   V14584 = "L3 CNTY MO GREW UP    HD"
   V14585 = "L4 OCCUPATION OF FA   HD"
   V14586 = "L5 FIRST OCCUPATION   HD"
   V14587 = "L6 # DIFF JOBS OR?    HD"
   V14588 = "L7 GREW UP FARM OR?   HD"
   V14589 = "L8-9 STATE GREW UP    HD"
   V14590 = "L8-9 CNTY GREW UP     HD"
   V14591 = "L8-10 #REGIONS LIVED  HD"
   V14592 = "L8-10 #STATES LIVED   HD"
   V14593 = "L11 EVER MOVE FOR JOB? H"
   V14594 = "L12 NOT MOVED FOR JOB? H"
   V14595 = "L13 PARENTS POOR OR?  HD"
   V14596 = "L14-15 EDUC OF FATHER  H"
   V14597 = "L16-17 EDUC OF MOTHER  H"
   V14598 = "L18 WHETHER BROTHERS  HD"
   V14599 = "L19 # BROTHERS      HEAD"
   V14600 = "L20 ONLY BRO STILL ALIVE"
   V14601 = "L21 ONLY BRO OLDR THAN H"
   V14602 = "L22 # BRO STILL ALIVE"
   V14603 = "L23 ANY BRO OLDR THAN H"
   V14604 = "L24 WHETHER SISTERS   HD"
   V14605 = "L25 # SISTERS       HEAD"
   V14606 = "L26 ONLY SIS STILL ALIVE"
   V14607 = "L27 ONLY SIS OLDR THAN H"
   V14608 = "L28 # SIS STILL ALIVE"
   V14609 = "L29 ANY SIS OLDR THAN H"
   V14610 = "L30 LIVE W BOTH PARENT H"
   V14611 = "L31 SPANISH DESCENT   HD"
   V14612 = "L32 RACE OF HEAD 1"
   V14613 = "L32 RACE OF HEAD 2"
   V14614 = "L33 WTR IN MILIT SERV  H"
   V14615 = "L34 WTR GRADUATED HS  HD"
   V14616 = "L35 MO GRADUATED HS   HD"
   V14617 = "L35 YR GRADUATED HS   HD"
   V14618 = "L36 GRADE LEVEL IF GED H"
   V14619 = "L37 MO LAST IN SCH-GED H"
   V14620 = "L37 YR LAST IN SCH-GED H"
   V14621 = "L38 MO RECEIVED GED   HD"
   V14622 = "L38 YR RECEIVED GED   HD"
   V14623 = "L39 GRD OF SCH FINISH  H"
   V14624 = "L40 MO LAST IN SCH-NONGR"
   V14625 = "L40 YR LAST IN SCH-NONGR"
   V14626 = "L41 WTR ATTEND COLLEGE H"
   V14627 = "L42 MO LAST ATTND COLL H"
   V14628 = "L42 YR LAST ATTND COLL H"
   V14629 = "L43 HGHST YR COLL COMP H"
   V14630 = "L44 WTR RECD COLL DEG  H"
   V14631 = "L45 HGHST COLL DEG REC H"
   V14632 = "L48 MO RECD COLL DEG  HD"
   V14633 = "L48 YR RECD COLL DEG  HD"
   V14634 = "L49 WTR REC OTR DEG/CERT"
   V14635 = "L49 # OTR DEG/CERT REC"
   V14636 = "L50 TYPE OTR DEG/CERT 1"
   V14637 = "L51 FIELD OF DEG/CERT 1"
   V14638 = "L52 INST/ORG DEG/CERT 1"
   V14639 = "L53 MO REC DEG/CERT 1"
   V14640 = "L53 YR REC DEG/CERT 1"
   V14641 = "L50 TYPE OTR DEG/CERT 2"
   V14642 = "L51 FIELD OF DEG/CERT 2"
   V14643 = "L52 INST/ORG DEG/CERT 2"
   V14644 = "L53 MO REC DEG/CERT 2"
   V14645 = "L53 YR REC DEG/CERT 2"
   V14646 = "L50 TYPE OTR DEG/CERT 3"
   V14647 = "L51 FIELD OF DEG/CERT 3"
   V14648 = "L52 INST/ORG DEG/CERT 3"
   V14649 = "L53 MO REC DEG/CERT 3"
   V14650 = "L53 YR REC DEG/CERT 3"
   V14651 = "L55-56 RELIGIOUS PREF  H"
   V14652 = "L57 #YRS WRKD SINCE 18 H"
   V14653 = "L58 #YR WRKD FULL-TIME H"
   V14654 = "TN1 WHO WAS RESPONDENT"
   V14655 = "TN2 # OF INTERVWR CALLS"
   V14656 = "# OF INDIVIDUAL RECORDS"
   V14657 = "H+W 1986 FED TAXES"
   V14658 = "H+W 86 MARGINAL TAX RATE"
   V14659 = "1ST XTRA ERNER 86 TAXES"
   V14660 = "MARG TAX RATE ERNR ONE"
   V14661 = "2ND XTRA ERNER 86 TAXES"
   V14662 = "MARG TAX RATE ERNR TWO"
   V14663 = "3RD XTRA ERNER 86 TAXES"
   V14664 = "MARG TAX RATE ERNR THREE"
   V14665 = "4TH XTRA ERNER 86 TAXES"
   V14666 = "MARG TAX RATE ERNR FOUR"
   V14667 = "5TH XTRA ERNER 86 TAXES"
   V14668 = "MARG TAX RATE ERNR FIVE"
   V14669 = "TOT TAXES ALL XTRA ERNR"
   V14670 = "TOT FAM MONEY Y 86"
   V14671 = "TOTAL HEAD LABOR Y 86"
   V14672 = "WEEKLY FOOD NEEDS-1987"
   V14673 = "ANNUAL NEEDS STD-1986"
   V14674 = "1986 TOT FAM Y/NEEDS"
   V14675 = "ANNUAL FOOD STD"
   V14676 = "HEAD 86 AVG HRLY EARNING"
   V14677 = "WIFE 86 AVG HRLY EARNING"
   V14678 = "REGION OF 1987 INTERVIEW"
   V14679 = "STATE CODE (FIPS)"
   V14680 = "COUNTY CODE (FIPS)"
   V14681 = "RURAL-URBAN CODE (BEALE)"
   V14682 = "REGION 87 HD GREW UP"
   V14683 = "HEAD GEOGRAPHIC MOBILITY"
   V14684 = "ACC 86 Y COMPONENTS"
   V14685 = "# MINOR ASSGMTS IN 87"
   V14686 = "# MAJOR ASSGMTS IN 87"
   V14687 = "EDUCATION 1987 HEAD"
   V14688 = "EDUCATION 1987 WIFE"
   V14689 = "DECILE: 86 TOT FAM Y"
   V14690 = "DECILE: 86 Y/NEEDS"
   V14691 = "# CHILDREN AGE 1-2"
   V14692 = "# CHILDREN AGE 3-5"
   V14693 = "# CHILDREN AGE 6-13"
   V14694 = "# FEM CHILDREN AGE 14-17"
   V14695 = "# MALE CHILDREN 14-17"
   V14696 = "# FEM CHILDREN 18-20"
   V14697 = "# MALE CHILDREN 18-20"
   V14698 = "# FEM CHILDREN 21-29"
   V14699 = "# MALE CHILDREN 21-29"
   V14700 = "# INDS IN ARMED FORCES"
   V14701 = "# INDS INCARCERATED"
   V14702 = "# INDS IN HLTH CARE FAC"
   V14703 = "# INDS IN EDUCATNL FACIL"
   V14704 = "SPLIT SAMPLE FILTER"
   V14705 = "BRR STRATUM"
   V14706 = "BRR SECU"
   V14707 = "PSALMS STRATUM"
   V14708 = "PSALMS SECU"
   V14709 = "UNSKLLD CNTY LABOR SUPPL"
   V14710 = "TYPICAL UNSKL WAGE RATE"
   V14711 = "1987 CNTY UNEMP RATE"
   V14712 = "MARITAL STATUS 1987"
   V14713 = "86-87 CNG MARITAL STATUS"
   V14714 = "COUPLE STATUS OF HEAD"
   V14715 = "YR NEW HEAD IN FU"
   V14716 = "YR NEW WIFE IN FU"
   V14717 = "HD-SPOUSE SAMPLE STATUS"
   V14718 = "# 87 S/O FROM THIS FAM"
   V14719 = "87 MAIN FAM ID FOR S/0"
   V14720 = "87ID OF 1ST OTR FU IN HU"
   V14721 = "REL OF 1ST OTHER FU"
   V14722 = "SIZE OF 1ST OTHER FU"
   V14723 = "87ID OF 2ND OTR FU IN HU"
   V14724 = "REL OF 2ND OTHER FU"
   V14725 = "SIZE OF 2ND OTHER FU"
   V14726 = "87ID OF 3RD OTR FU IN HU"
   V14727 = "REL OF 3RD OTHER FU"
   V14728 = "SIZE OF 3RD OTHER FU"
   V14729 = "87ID OF 4TH OTR FU IN HU"
   V14730 = "REL OF 4TH OTHER FU"
   V14731 = "SIZE OF 4TH OTHER FU"
   V14732 = "HOUSEHOLD ID #"
   V14733 = "# BORN TO HD ONLY IN 86"
   V14734 = "#BORN TO W/'W' ONLY IN86"
   V14735 = "#BRN TO H+W JOINTLY IN86"
   V14736 = "# BORN TO OFUMS IN 86"
   V14737 = "1987 FAMILY WEIGHT";

* USER-DEFINED MISSING VALUE RECODE TO SAS SYSMIS;

IF V13703=99 THEN V13703=.;
IF V13704=999 THEN V13704=.;
IF V13705=99999 THEN V13705=.;
IF V13706=9 THEN V13706=.;
IF V13708=9 THEN V13708=.;
IF V13709=9 THEN V13709=.;
IF V13710=9 THEN V13710=.;
IF V13717=9999 THEN V13717=.;
IF V13718=999 THEN V13718=.;
IF V13719=99 THEN V13719=.;
IF V13720=9 THEN V13720=.;
IF V13721=99 THEN V13721=.;
IF V13738=9999 THEN V13738=.;
IF V13756=9 THEN V13756=.;
IF V13757=9 THEN V13757=.;
IF V13758=9 THEN V13758=.;
IF V13759=9 THEN V13759=.;
IF V13760=9 THEN V13760=.;
IF V13761=9 THEN V13761=.;
IF V13762=9 THEN V13762=.;
IF V13763=9 THEN V13763=.;
IF V13764=9 THEN V13764=.;
IF V13765=9 THEN V13765=.;
IF V13766=9 THEN V13766=.;
IF V13767=9 THEN V13767=.;
IF V13768=9 THEN V13768=.;
IF V13769=9 THEN V13769=.;
IF V13770=9 THEN V13770=.;
IF V13771=9 THEN V13771=.;
IF V13772=9 THEN V13772=.;
IF V13773=9 THEN V13773=.;
IF V13774=9 THEN V13774=.;
IF V13775=9 THEN V13775=.;
IF V13776=9 THEN V13776=.;
IF V13777=9 THEN V13777=.;
IF V13779=9 THEN V13779=.;
IF V13780=9 THEN V13780=.;
IF V13781=9 THEN V13781=.;
IF V13782=9 THEN V13782=.;
IF V13783=9 THEN V13783=.;
IF V13784=9 THEN V13784=.;
IF V13785=9 THEN V13785=.;
IF V13786=9 THEN V13786=.;
IF V13787=9 THEN V13787=.;
IF V13788=9 THEN V13788=.;
IF V13789=9 THEN V13789=.;
IF V13790=9 THEN V13790=.;
IF V13791=9 THEN V13791=.;
IF V13792=9 THEN V13792=.;
IF V13793=9 THEN V13793=.;
IF V13794=9 THEN V13794=.;
IF V13795=9 THEN V13795=.;
IF V13796=9 THEN V13796=.;
IF V13797=9 THEN V13797=.;
IF V13798=9 THEN V13798=.;
IF V13799=9 THEN V13799=.;
IF V13800=9 THEN V13800=.;
IF V13820=9 THEN V13820=.;
IF V13821=9 THEN V13821=.;
IF V13822=9 THEN V13822=.;
IF V13823=9 THEN V13823=.;
IF V13824=9 THEN V13824=.;
IF V13825=9 THEN V13825=.;
IF V13826=9 THEN V13826=.;
IF V13827=9 THEN V13827=.;
IF V13828=9 THEN V13828=.;
IF V13829=9 THEN V13829=.;
IF V13830=9 THEN V13830=.;
IF V13831=9 THEN V13831=.;
IF V13832=9 THEN V13832=.;
IF V13833=9 THEN V13833=.;
IF V13834=9 THEN V13834=.;
IF V13835=9 THEN V13835=.;
IF V13836=9 THEN V13836=.;
IF V13837=9 THEN V13837=.;
IF V13838=9 THEN V13838=.;
IF V13839=9 THEN V13839=.;
IF V13840=9 THEN V13840=.;
IF V13841=9 THEN V13841=.;
IF V13843=9 THEN V13843=.;
IF V13844=9 THEN V13844=.;
IF V13845=9 THEN V13845=.;
IF V13846=9 THEN V13846=.;
IF V13847=9 THEN V13847=.;
IF V13848=9 THEN V13848=.;
IF V13849=9 THEN V13849=.;
IF V13850=9 THEN V13850=.;
IF V13851=9 THEN V13851=.;
IF V13852=9 THEN V13852=.;
IF V13853=9 THEN V13853=.;
IF V13854=9 THEN V13854=.;
IF V13855=9 THEN V13855=.;
IF V13856=9 THEN V13856=.;
IF V13857=9 THEN V13857=.;
IF V13858=9 THEN V13858=.;
IF V13859=9 THEN V13859=.;
IF V13860=9 THEN V13860=.;
IF V13861=9 THEN V13861=.;
IF V13862=9 THEN V13862=.;
IF V13863=9 THEN V13863=.;
IF V13864=9 THEN V13864=.;
IF V13873=9 THEN V13873=.;
IF V13881=9 THEN V13881=.;
IF V13882=99 THEN V13882=.;
IF V13883=9 THEN V13883=.;
IF V13884=9 THEN V13884=.;
IF V13885=9 THEN V13885=.;
IF V13886=9 THEN V13886=.;
IF V13887=9 THEN V13887=.;
IF V13888=9 THEN V13888=.;
IF V13889=9 THEN V13889=.;
IF V13890=9 THEN V13890=.;
IF V13891=9 THEN V13891=.;
IF V13892=9 THEN V13892=.;
IF V13893=9 THEN V13893=.;
IF V13894=9 THEN V13894=.;
IF V13912=99 THEN V13912=.;
IF V13914=99 THEN V13914=.;
IF V13916=99 THEN V13916=.;
IF V13921=99999 THEN V13921=.;
IF V13922=99999 THEN V13922=.;
IF V13923=99999 THEN V13923=.;
IF V13930=99 THEN V13930=.;
IF V13933=99 THEN V13933=.;
IF V13935=9 THEN V13935=.;
IF V13936=99 THEN V13936=.;
IF V13938=99 THEN V13938=.;
IF V13940=9 THEN V13940=.;
IF V13943=99 THEN V13943=.;
IF V13945=99 THEN V13945=.;
IF V13947=99 THEN V13947=.;
IF V13951=99 THEN V13951=.;
IF V13954=99 THEN V13954=.;
IF V13956=9 THEN V13956=.;
IF V13957=99 THEN V13957=.;
IF V13959=99 THEN V13959=.;
IF V13963=99 THEN V13963=.;
IF V13965=99 THEN V13965=.;
IF V13967=99 THEN V13967=.;
IF V13971=9 THEN V13971=.;
IF V13972=9 THEN V13972=.;
IF V13973=9 THEN V13973=.;
IF V13974=9 THEN V13974=.;
IF V13975=9 THEN V13975=.;
IF V13976=9 THEN V13976=.;
IF V13977=9 THEN V13977=.;
IF V13978=9 THEN V13978=.;
IF V13979=9 THEN V13979=.;
IF V13980=9 THEN V13980=.;
IF V13981=9 THEN V13981=.;
IF V13982=9 THEN V13982=.;
IF V13983=9 THEN V13983=.;
IF V13984=9 THEN V13984=.;
IF V13985=9 THEN V13985=.;
IF V13986=9 THEN V13986=.;
IF V13987=9 THEN V13987=.;
IF V13988=9 THEN V13988=.;
IF V13989=9 THEN V13989=.;
IF V13990=9 THEN V13990=.;
IF V13991=9 THEN V13991=.;
IF V13992=9 THEN V13992=.;
IF V13993=9 THEN V13993=.;
IF V13994=9 THEN V13994=.;
IF V13995=9 THEN V13995=.;
IF V13996=9 THEN V13996=.;
IF V13997=9 THEN V13997=.;
IF V13998=9 THEN V13998=.;
IF V13999=9 THEN V13999=.;
IF V14000=9 THEN V14000=.;
IF V14001=9 THEN V14001=.;
IF V14002=9 THEN V14002=.;
IF V14003=9 THEN V14003=.;
IF V14004=9 THEN V14004=.;
IF V14005=9 THEN V14005=.;
IF V14006=9 THEN V14006=.;
IF V14007=9 THEN V14007=.;
IF V14008=9 THEN V14008=.;
IF V14009=9 THEN V14009=.;
IF V14010=9 THEN V14010=.;
IF V14011=9 THEN V14011=.;
IF V14012=9 THEN V14012=.;
IF V14013=9 THEN V14013=.;
IF V14014=9 THEN V14014=.;
IF V14015=9 THEN V14015=.;
IF V14016=9 THEN V14016=.;
IF V14017=9 THEN V14017=.;
IF V14018=9 THEN V14018=.;
IF V14019=9 THEN V14019=.;
IF V14020=9 THEN V14020=.;
IF V14021=9 THEN V14021=.;
IF V14022=9 THEN V14022=.;
IF V14023=9 THEN V14023=.;
IF V14024=9 THEN V14024=.;
IF V14025=9 THEN V14025=.;
IF V14026=9 THEN V14026=.;
IF V14027=9 THEN V14027=.;
IF V14028=9 THEN V14028=.;
IF V14029=9 THEN V14029=.;
IF V14030=9 THEN V14030=.;
IF V14031=9 THEN V14031=.;
IF V14032=9 THEN V14032=.;
IF V14033=9 THEN V14033=.;
IF V14034=9 THEN V14034=.;
IF V14035=9 THEN V14035=.;
IF V14036=9 THEN V14036=.;
IF V14037=9 THEN V14037=.;
IF V14038=9 THEN V14038=.;
IF V14039=9 THEN V14039=.;
IF V14040=9 THEN V14040=.;
IF V14041=9 THEN V14041=.;
IF V14042=9 THEN V14042=.;
IF V14109=9999 THEN V14109=.;
IF V14110=999 THEN V14110=.;
IF V14111=9999 THEN V14111=.;
IF V14112=999 THEN V14112=.;
IF V14114=99 THEN V14114=.;
IF V14116=99 THEN V14116=.;
IF V14118=99 THEN V14118=.;
IF V14119=99 THEN V14119=.;
IF V14120=9 THEN V14120=.;
IF V14121=9 THEN V14121=.;
IF V14122=99 THEN V14122=.;
IF V14123=99 THEN V14123=.;
IF V14124=99 THEN V14124=.;
IF V14125=9 THEN V14125=.;
IF V14127=9 THEN V14127=.;
IF V14128=99 THEN V14128=.;
IF V14129=9 THEN V14129=.;
IF V14130=9 THEN V14130=.;
IF V14131=9 THEN V14131=.;
IF V14132=9 THEN V14132=.;
IF V14133=9 THEN V14133=.;
IF V14134=9 THEN V14134=.;
IF V14135=9 THEN V14135=.;
IF V14136=9 THEN V14136=.;
IF V14137=9 THEN V14137=.;
IF V14138=9 THEN V14138=.;
IF V14139=9 THEN V14139=.;
IF V14140=9 THEN V14140=.;
IF V14141=99 THEN V14141=.;
IF V14142=9 THEN V14142=.;
IF V14143=9 THEN V14143=.;
IF V14144=9 THEN V14144=.;
IF V14145=9 THEN V14145=.;
IF V14147=99 THEN V14147=.;
IF V14148=9 THEN V14148=.;
IF V14149=9 THEN V14149=.;
IF V14150=9 THEN V14150=.;
IF V14151=9 THEN V14151=.;
IF V14152=9 THEN V14152=.;
IF V14153=9 THEN V14153=.;
IF V14154=999 THEN V14154=.;
IF V14155=999 THEN V14155=.;
IF V14156=9 THEN V14156=.;
IF V14157=9999 THEN V14157=.;
IF V14158=9 THEN V14158=.;
IF V14159=9999 THEN V14159=.;
IF V14160=9999 THEN V14160=.;
IF V14161=9999 THEN V14161=.;
IF V14162=9 THEN V14162=.;
IF V14163=9999 THEN V14163=.;
IF V14164=9 THEN V14164=.;
IF V14165=9 THEN V14165=.;
IF V14166=999 THEN V14166=.;
IF V14167=999 THEN V14167=.;
IF V14168=99 THEN V14168=.;
IF V14169=99 THEN V14169=.;
IF V14170=9 THEN V14170=.;
IF V14171=9999 THEN V14171=.;
IF V14172=99 THEN V14172=.;
IF V14173=9 THEN V14173=.;
IF V14174=9 THEN V14174=.;
IF V14175=9 THEN V14175=.;
IF V14176=9 THEN V14176=.;
IF V14177=9 THEN V14177=.;
IF V14178=99 THEN V14178=.;
IF V14179=99 THEN V14179=.;
IF V14180=9 THEN V14180=.;
IF V14181=999 THEN V14181=.;
IF V14182=999 THEN V14182=.;
IF V14183=9999 THEN V14183=.;
IF V14184=99 THEN V14184=.;
IF V14185=99 THEN V14185=.;
IF V14186=99 THEN V14186=.;
IF V14187=9 THEN V14187=.;
IF V14188=9999 THEN V14188=.;
IF V14189=99 THEN V14189=.;
IF V14191=9 THEN V14191=.;
IF V14192=99 THEN V14192=.;
IF V14193=9 THEN V14193=.;
IF V14194=99 THEN V14194=.;
IF V14195=9 THEN V14195=.;
IF V14196=99 THEN V14196=.;
IF V14197=9 THEN V14197=.;
IF V14198=99 THEN V14198=.;
IF V14199=9 THEN V14199=.;
IF V14200=99 THEN V14200=.;
IF V14201=9 THEN V14201=.;
IF V14202=99 THEN V14202=.;
IF V14203=99 THEN V14203=.;
IF V14204=99 THEN V14204=.;
IF V14205=9 THEN V14205=.;
IF V14206=9 THEN V14206=.;
IF V14207=9 THEN V14207=.;
IF V14208=99 THEN V14208=.;
IF V14209=9999 THEN V14209=.;
IF V14210=99 THEN V14210=.;
IF V14211=99 THEN V14211=.;
IF V14212=99 THEN V14212=.;
IF V14213=9999 THEN V14213=.;
IF V14214=99 THEN V14214=.;
IF V14215=99 THEN V14215=.;
IF V14216=9 THEN V14216=.;
IF V14217=99 THEN V14217=.;
IF V14218=9 THEN V14218=.;
IF V14219=99 THEN V14219=.;
IF V14220=99 THEN V14220=.;
IF V14221=99 THEN V14221=.;
IF V14222=9 THEN V14222=.;
IF V14223=9 THEN V14223=.;
IF V14224=99 THEN V14224=.;
IF V14225=99 THEN V14225=.;
IF V14226=99 THEN V14226=.;
IF V14227=99 THEN V14227=.;
IF V14228=99 THEN V14228=.;
IF V14229=99 THEN V14229=.;
IF V14230=9 THEN V14230=.;
IF V14231=9999 THEN V14231=.;
IF V14232=9 THEN V14232=.;
IF V14233=9 THEN V14233=.;
IF V14234=9 THEN V14234=.;
IF V14235=9 THEN V14235=.;
IF V14236=9 THEN V14236=.;
IF V14237=9 THEN V14237=.;
IF V14238=9 THEN V14238=.;
IF V14239=99 THEN V14239=.;
IF V14240=9 THEN V14240=.;
IF V14241=9999 THEN V14241=.;
IF V14242=99 THEN V14242=.;
IF V14243=9 THEN V14243=.;
IF V14244=99 THEN V14244=.;
IF V14245=9 THEN V14245=.;
IF V14246=99 THEN V14246=.;
IF V14247=99 THEN V14247=.;
IF V14248=9 THEN V14248=.;
IF V14249=99 THEN V14249=.;
IF V14250=9 THEN V14250=.;
IF V14251=99 THEN V14251=.;
IF V14252=999 THEN V14252=.;
IF V14253=999 THEN V14253=.;
IF V14254=9 THEN V14254=.;
IF V14255=9 THEN V14255=.;
IF V14256=9 THEN V14256=.;
IF V14257=99 THEN V14257=.;
IF V14258=99 THEN V14258=.;
IF V14259=9999 THEN V14259=.;
IF V14260=99 THEN V14260=.;
IF V14261=99 THEN V14261=.;
IF V14262=99 THEN V14262=.;
IF V14263=9 THEN V14263=.;
IF V14264=9999 THEN V14264=.;
IF V14265=99 THEN V14265=.;
IF V14266=9 THEN V14266=.;
IF V14267=9 THEN V14267=.;
IF V14268=9 THEN V14268=.;
IF V14269=99 THEN V14269=.;
IF V14270=99 THEN V14270=.;
IF V14271=9 THEN V14271=.;
IF V14272=999 THEN V14272=.;
IF V14273=999 THEN V14273=.;
IF V14274=9999 THEN V14274=.;
IF V14275=99 THEN V14275=.;
IF V14276=99 THEN V14276=.;
IF V14277=99 THEN V14277=.;
IF V14278=9 THEN V14278=.;
IF V14279=9999 THEN V14279=.;
IF V14280=99 THEN V14280=.;
IF V14282=9 THEN V14282=.;
IF V14283=99 THEN V14283=.;
IF V14284=9 THEN V14284=.;
IF V14285=99 THEN V14285=.;
IF V14286=9 THEN V14286=.;
IF V14287=99 THEN V14287=.;
IF V14288=9 THEN V14288=.;
IF V14289=99 THEN V14289=.;
IF V14290=9 THEN V14290=.;
IF V14291=99 THEN V14291=.;
IF V14292=9 THEN V14292=.;
IF V14293=99 THEN V14293=.;
IF V14294=99 THEN V14294=.;
IF V14295=99 THEN V14295=.;
IF V14296=9 THEN V14296=.;
IF V14297=9 THEN V14297=.;
IF V14298=99 THEN V14298=.;
IF V14299=9999 THEN V14299=.;
IF V14300=99 THEN V14300=.;
IF V14301=99 THEN V14301=.;
IF V14302=99 THEN V14302=.;
IF V14303=9999 THEN V14303=.;
IF V14304=99 THEN V14304=.;
IF V14305=99 THEN V14305=.;
IF V14306=9 THEN V14306=.;
IF V14307=99 THEN V14307=.;
IF V14308=9 THEN V14308=.;
IF V14309=99 THEN V14309=.;
IF V14310=99 THEN V14310=.;
IF V14311=99 THEN V14311=.;
IF V14312=9 THEN V14312=.;
IF V14313=9 THEN V14313=.;
IF V14314=99 THEN V14314=.;
IF V14315=99 THEN V14315=.;
IF V14316=99 THEN V14316=.;
IF V14317=99 THEN V14317=.;
IF V14318=99 THEN V14318=.;
IF V14319=99 THEN V14319=.;
IF V14322=99 THEN V14322=.;
IF V14323=9 THEN V14323=.;
IF V14324=9 THEN V14324=.;
IF V14325=9 THEN V14325=.;
IF V14326=9 THEN V14326=.;
IF V14327=9 THEN V14327=.;
IF V14328=9 THEN V14328=.;
IF V14329=999 THEN V14329=.;
IF V14330=999 THEN V14330=.;
IF V14331=9 THEN V14331=.;
IF V14332=9999 THEN V14332=.;
IF V14333=9 THEN V14333=.;
IF V14334=9999 THEN V14334=.;
IF V14335=9999 THEN V14335=.;
IF V14336=9999 THEN V14336=.;
IF V14337=9 THEN V14337=.;
IF V14338=9999 THEN V14338=.;
IF V14339=999 THEN V14339=.;
IF V14340=999 THEN V14340=.;
IF V14341=99 THEN V14341=.;
IF V14342=99 THEN V14342=.;
IF V14343=9 THEN V14343=.;
IF V14344=9999 THEN V14344=.;
IF V14345=99 THEN V14345=.;
IF V14346=9 THEN V14346=.;
IF V14347=9 THEN V14347=.;
IF V14348=9 THEN V14348=.;
IF V14349=9 THEN V14349=.;
IF V14350=9 THEN V14350=.;
IF V14351=99 THEN V14351=.;
IF V14352=99 THEN V14352=.;
IF V14353=9 THEN V14353=.;
IF V14354=999 THEN V14354=.;
IF V14355=999 THEN V14355=.;
IF V14356=9999 THEN V14356=.;
IF V14357=99 THEN V14357=.;
IF V14358=99 THEN V14358=.;
IF V14359=99 THEN V14359=.;
IF V14360=9 THEN V14360=.;
IF V14361=9999 THEN V14361=.;
IF V14362=99 THEN V14362=.;
IF V14364=9 THEN V14364=.;
IF V14365=99 THEN V14365=.;
IF V14366=9 THEN V14366=.;
IF V14367=99 THEN V14367=.;
IF V14368=9 THEN V14368=.;
IF V14369=99 THEN V14369=.;
IF V14370=9 THEN V14370=.;
IF V14371=99 THEN V14371=.;
IF V14372=9 THEN V14372=.;
IF V14373=99 THEN V14373=.;
IF V14374=9 THEN V14374=.;
IF V14375=99 THEN V14375=.;
IF V14376=99 THEN V14376=.;
IF V14377=99 THEN V14377=.;
IF V14378=9 THEN V14378=.;
IF V14379=9 THEN V14379=.;
IF V14380=9 THEN V14380=.;
IF V14381=99 THEN V14381=.;
IF V14382=9999 THEN V14382=.;
IF V14383=99 THEN V14383=.;
IF V14384=99 THEN V14384=.;
IF V14385=99 THEN V14385=.;
IF V14386=9999 THEN V14386=.;
IF V14387=99 THEN V14387=.;
IF V14388=99 THEN V14388=.;
IF V14389=9 THEN V14389=.;
IF V14390=99 THEN V14390=.;
IF V14391=9 THEN V14391=.;
IF V14392=99 THEN V14392=.;
IF V14393=99 THEN V14393=.;
IF V14394=99 THEN V14394=.;
IF V14395=9 THEN V14395=.;
IF V14396=9 THEN V14396=.;
IF V14397=99 THEN V14397=.;
IF V14398=99 THEN V14398=.;
IF V14399=99 THEN V14399=.;
IF V14400=99 THEN V14400=.;
IF V14401=99 THEN V14401=.;
IF V14402=99 THEN V14402=.;
IF V14403=9 THEN V14403=.;
IF V14404=9 THEN V14404=.;
IF V14405=99 THEN V14405=.;
IF V14406=9 THEN V14406=.;
IF V14407=99 THEN V14407=.;
IF V14408=9 THEN V14408=.;
IF V14409=9 THEN V14409=.;
IF V14410=99 THEN V14410=.;
IF V14411=99 THEN V14411=.;
IF V14412=9 THEN V14412=.;
IF V14413=99 THEN V14413=.;
IF V14414=9 THEN V14414=.;
IF V14415=99 THEN V14415=.;
IF V14416=999 THEN V14416=.;
IF V14417=999 THEN V14417=.;
IF V14418=9 THEN V14418=.;
IF V14419=9 THEN V14419=.;
IF V14420=9 THEN V14420=.;
IF V14421=99 THEN V14421=.;
IF V14422=99 THEN V14422=.;
IF V14423=9999 THEN V14423=.;
IF V14424=99 THEN V14424=.;
IF V14425=99 THEN V14425=.;
IF V14426=99 THEN V14426=.;
IF V14427=9 THEN V14427=.;
IF V14428=9999 THEN V14428=.;
IF V14429=99 THEN V14429=.;
IF V14430=9 THEN V14430=.;
IF V14431=9 THEN V14431=.;
IF V14432=9 THEN V14432=.;
IF V14433=99 THEN V14433=.;
IF V14434=99 THEN V14434=.;
IF V14435=9 THEN V14435=.;
IF V14436=999 THEN V14436=.;
IF V14437=999 THEN V14437=.;
IF V14438=9999 THEN V14438=.;
IF V14439=99 THEN V14439=.;
IF V14440=99 THEN V14440=.;
IF V14441=99 THEN V14441=.;
IF V14442=9 THEN V14442=.;
IF V14443=9999 THEN V14443=.;
IF V14444=99 THEN V14444=.;
IF V14446=9 THEN V14446=.;
IF V14447=99 THEN V14447=.;
IF V14448=9 THEN V14448=.;
IF V14449=99 THEN V14449=.;
IF V14450=9 THEN V14450=.;
IF V14451=99 THEN V14451=.;
IF V14452=9 THEN V14452=.;
IF V14453=99 THEN V14453=.;
IF V14454=9 THEN V14454=.;
IF V14455=99 THEN V14455=.;
IF V14456=9 THEN V14456=.;
IF V14457=99 THEN V14457=.;
IF V14458=99 THEN V14458=.;
IF V14459=99 THEN V14459=.;
IF V14460=9 THEN V14460=.;
IF V14461=9 THEN V14461=.;
IF V14462=99 THEN V14462=.;
IF V14463=9999 THEN V14463=.;
IF V14464=99 THEN V14464=.;
IF V14465=99 THEN V14465=.;
IF V14466=99 THEN V14466=.;
IF V14467=9999 THEN V14467=.;
IF V14468=99 THEN V14468=.;
IF V14469=99 THEN V14469=.;
IF V14470=9 THEN V14470=.;
IF V14471=99 THEN V14471=.;
IF V14472=9 THEN V14472=.;
IF V14473=99 THEN V14473=.;
IF V14474=99 THEN V14474=.;
IF V14475=99 THEN V14475=.;
IF V14476=9 THEN V14476=.;
IF V14477=9 THEN V14477=.;
IF V14478=99 THEN V14478=.;
IF V14479=99 THEN V14479=.;
IF V14480=99 THEN V14480=.;
IF V14481=99 THEN V14481=.;
IF V14482=99 THEN V14482=.;
IF V14483=99 THEN V14483=.;
IF V14485=99 THEN V14485=.;
IF V14486=99 THEN V14486=.;
IF V14487=9 THEN V14487=.;
IF V14488=9 THEN V14488=.;
IF V14489=9 THEN V14489=.;
IF V14490=9 THEN V14490=.;
IF V14491=9 THEN V14491=.;
IF V14492=9 THEN V14492=.;
IF V14493=9 THEN V14493=.;
IF V14494=9 THEN V14494=.;
IF V14495=999999 THEN V14495=.;
IF V14496=9 THEN V14496=.;
IF V14497=99 THEN V14497=.;
IF V14498=9 THEN V14498=.;
IF V14499=9 THEN V14499=.;
IF V14500=9 THEN V14500=.;
IF V14501=9 THEN V14501=.;
IF V14502=999999 THEN V14502=.;
IF V14503=9 THEN V14503=.;
IF V14504=9 THEN V14504=.;
IF V14505=9 THEN V14505=.;
IF V14506=99 THEN V14506=.;
IF V14507=99 THEN V14507=.;
IF V14508=99 THEN V14508=.;
IF V14509=9 THEN V14509=.;
IF V14510=9 THEN V14510=.;
IF V14511=9 THEN V14511=.;
IF V14512=9 THEN V14512=.;
IF V14513=9 THEN V14513=.;
IF V14514=9 THEN V14514=.;
IF V14515=9 THEN V14515=.;
IF V14516=9 THEN V14516=.;
IF V14517=9 THEN V14517=.;
IF V14518=9 THEN V14518=.;
IF V14519=999 THEN V14519=.;
IF V14520=9 THEN V14520=.;
IF V14522=9 THEN V14522=.;
IF V14524=9 THEN V14524=.;
IF V14525=9 THEN V14525=.;
IF V14526=9 THEN V14526=.;
IF V14527=9 THEN V14527=.;
IF V14528=9 THEN V14528=.;
IF V14529=9 THEN V14529=.;
IF V14530=999 THEN V14530=.;
IF V14532=9 THEN V14532=.;
IF V14533=9 THEN V14533=.;
IF V14534=9 THEN V14534=.;
IF V14535=99 THEN V14535=.;
IF V14536=9 THEN V14536=.;
IF V14537=9 THEN V14537=.;
IF V14538=99 THEN V14538=.;
IF V14539=9 THEN V14539=.;
IF V14540=9 THEN V14540=.;
IF V14541=99 THEN V14541=.;
IF V14542=9 THEN V14542=.;
IF V14543=9 THEN V14543=.;
IF V14544=99 THEN V14544=.;
IF V14545=9 THEN V14545=.;
IF V14546=9 THEN V14546=.;
IF V14547=9 THEN V14547=.;
IF V14548=9 THEN V14548=.;
IF V14549=9 THEN V14549=.;
IF V14550=9 THEN V14550=.;
IF V14551=99 THEN V14551=.;
IF V14552=99 THEN V14552=.;
IF V14553=99 THEN V14553=.;
IF V14554=99 THEN V14554=.;
IF V14555=99 THEN V14555=.;
IF V14556=99 THEN V14556=.;
IF V14557=9 THEN V14557=.;
IF V14558=99 THEN V14558=.;
IF V14559=9 THEN V14559=.;
IF V14560=9 THEN V14560=.;
IF V14561=99 THEN V14561=.;
IF V14562=99 THEN V14562=.;
IF V14563=9 THEN V14563=.;
IF V14564=9 THEN V14564=.;
IF V14565=9 THEN V14565=.;
IF V14566=99 THEN V14566=.;
IF V14567=99 THEN V14567=.;
IF V14568=99 THEN V14568=.;
IF V14569=9 THEN V14569=.;
IF V14570=99 THEN V14570=.;
IF V14571=99 THEN V14571=.;
IF V14572=99 THEN V14572=.;
IF V14573=9 THEN V14573=.;
IF V14574=99 THEN V14574=.;
IF V14575=99 THEN V14575=.;
IF V14576=99 THEN V14576=.;
IF V14577=99 THEN V14577=.;
IF V14578=99 THEN V14578=.;
IF V14579=99 THEN V14579=.;
IF V14581=99 THEN V14581=.;
IF V14582=999 THEN V14582=.;
IF V14583=99 THEN V14583=.;
IF V14584=999 THEN V14584=.;
IF V14585=9 THEN V14585=.;
IF V14586=9 THEN V14586=.;
IF V14587=9 THEN V14587=.;
IF V14588=9 THEN V14588=.;
IF V14589=99 THEN V14589=.;
IF V14590=999 THEN V14590=.;
IF V14591=9 THEN V14591=.;
IF V14592=9 THEN V14592=.;
IF V14593=9 THEN V14593=.;
IF V14594=9 THEN V14594=.;
IF V14595=9 THEN V14595=.;
IF V14596=9 THEN V14596=.;
IF V14597=9 THEN V14597=.;
IF V14598=9 THEN V14598=.;
IF V14599=99 THEN V14599=.;
IF V14600=9 THEN V14600=.;
IF V14601=9 THEN V14601=.;
IF V14602=99 THEN V14602=.;
IF V14603=9 THEN V14603=.;
IF V14604=9 THEN V14604=.;
IF V14605=99 THEN V14605=.;
IF V14606=9 THEN V14606=.;
IF V14607=9 THEN V14607=.;
IF V14608=99 THEN V14608=.;
IF V14609=9 THEN V14609=.;
IF V14610=9 THEN V14610=.;
IF V14611=9 THEN V14611=.;
IF V14612=9 THEN V14612=.;
IF V14613=9 THEN V14613=.;
IF V14614=9 THEN V14614=.;
IF V14615=9 THEN V14615=.;
IF V14616=99 THEN V14616=.;
IF V14617=99 THEN V14617=.;
IF V14618=99 THEN V14618=.;
IF V14619=99 THEN V14619=.;
IF V14620=99 THEN V14620=.;
IF V14621=99 THEN V14621=.;
IF V14622=99 THEN V14622=.;
IF V14623=99 THEN V14623=.;
IF V14624=99 THEN V14624=.;
IF V14625=99 THEN V14625=.;
IF V14626=9 THEN V14626=.;
IF V14627=99 THEN V14627=.;
IF V14628=99 THEN V14628=.;
IF V14629=9 THEN V14629=.;
IF V14630=9 THEN V14630=.;
IF V14631=99 THEN V14631=.;
IF V14632=99 THEN V14632=.;
IF V14633=99 THEN V14633=.;
IF V14634=9 THEN V14634=.;
IF V14635=9 THEN V14635=.;
IF V14636=9 THEN V14636=.;
IF V14637=99 THEN V14637=.;
IF V14638=99 THEN V14638=.;
IF V14639=99 THEN V14639=.;
IF V14640=99 THEN V14640=.;
IF V14641=9 THEN V14641=.;
IF V14642=99 THEN V14642=.;
IF V14643=99 THEN V14643=.;
IF V14644=99 THEN V14644=.;
IF V14645=99 THEN V14645=.;
IF V14646=9 THEN V14646=.;
IF V14647=99 THEN V14647=.;
IF V14648=99 THEN V14648=.;
IF V14649=99 THEN V14649=.;
IF V14650=99 THEN V14650=.;
IF V14651=99 THEN V14651=.;
IF V14652=99 THEN V14652=.;
IF V14653=99 THEN V14653=.;
IF V14654=9 THEN V14654=.;
IF V14655=99 THEN V14655=.;
IF V14678=9 THEN V14678=.;
IF V14679=99 THEN V14679=.;
IF V14680=999 THEN V14680=.;
IF V14681=99 THEN V14681=.;
IF V14682=9 THEN V14682=.;
IF V14683=9 THEN V14683=.;
IF V14687=9 THEN V14687=.;
IF V14688=9 THEN V14688=.;
IF V14709=9 THEN V14709=.;
IF V14710=9999 THEN V14710=.;
IF V14711=99 THEN V14711=.;
IF V14715=99 THEN V14715=.;
IF V14733=9 THEN V14733=.;
IF V14734=9 THEN V14734=.;
IF V14735=9 THEN V14735=.;
IF V14736=9 THEN V14736=.;
 
file rawdat lrecl=2039;
put    
v13702
v13710
v13724
v13725
v13726
v13732
v13733
v13736
v13737
v13745
v13746
v13748
v13809
v13810
v13812
v13874
v13875
v13876
v13877
v13878
v13879
v13880
v13881
v13904
v13905
v13906
v13913
v13915
v13918
v13920
v13970
v14069
v14070
v14072
v14086
v14111
v14113
v14114
v14115
v14116
v14126
v14127
v14128
v14129
v14140
v14141
v14142
v14146
v14149
v14166
v14177
v14203
v14204
v14242
v14256
v14294
v14295
v14321
v14323
v14324
v14339
v14350
v14376
v14377
v14407
v14420
v14458
v14459
v14502
v14505
v14515
v14550
v14557
v14560
v14580
v14612
v14615
v14626
v14630
v14657
v14658
v14669
v14670
v14671
v14673
v14678
v14684
v14687
v14688
v14712
v14737
v30555
;

 proc means;
 run; 
